% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/qqgauss.r
\name{qqgauss}
\alias{qqgauss}
\title{Function for producing a QQ plot for a Gaussian
probability density function.}
\usage{
qqgauss(y = y, linecol = "red", xlab = NULL, ylab = NULL, eng = TRUE, ...)
}
\arguments{
\item{y}{A numeric vector representing the Y-random variable}

\item{linecol}{A string specifying the 1:1 straight-line color.
The default is set to "red".}

\item{xlab}{(optional) A string specifying X-axis label.
If not provide it, uses the default setting.}

\item{ylab}{(optional) A string specifying Y-axis label.
If not provide it, uses the default setting.}

\item{eng}{logical; if \code{TRUE} (by default), the language of the
statistics will be in English; if "FALSE" will be in Spanish.}

\item{...}{other graphical parameters (see par and
section 'Details' below).}
}
\value{
The function returns the above described graph.
}
\description{
The function creates a QQ plot for a given random
variable \code{y} and a Gaussian probability density function.
This graph is a scatterplot between the sample
quantiles of the data and the theoretical quantiles,
following the Gaussian pdf.
}
\details{
Notice that the reference pdf model is
the Gaussian one, i.e., uses the \code{qnorm()} function.
}
\examples{
df <- datana::maple
head(df)
m1<-lm(leaf~dbh,data=df)
# Example 1, a residual plot
qqgauss(residuals(m1))
}
\references{
\itemize{
\item Salas-Eljatib C. 2021. Análisis de datos con el programa
estadístico R:
una introducción aplicada.
Ediciones Universidad Mayor. Santiago, Chile. 170 p.
\url{https://eljatib.com}
}
}
\author{
Christian Salas-Eljatib
}
