% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/interval_uncertainty.R
\name{interval_uncertainty}
\alias{interval_uncertainty}
\alias{int_entropy}
\alias{int_cv}
\alias{int_dispersion}
\alias{int_imprecision}
\alias{int_granularity}
\alias{int_uniformity}
\alias{int_information_content}
\title{Uncertainty and Variability Measures for Interval Data}
\usage{
int_entropy(x, var_name, method = "CM", base = 2, ...)

int_cv(x, var_name, method = "CM", ...)

int_dispersion(x, var_name, method = "CM", ...)

int_imprecision(x, var_name, ...)

int_granularity(x, var_name, ...)

int_uniformity(x, var_name, ...)

int_information_content(x, var_name, method = "CM", ...)
}
\arguments{
\item{x}{interval-valued data with symbolic_tbl class.}

\item{var_name}{the variable name or the column location (multiple variables are allowed).}

\item{method}{methods to calculate statistics: CM (default), VM, QM, SE, FV, EJD, GQ, SPT.}

\item{base}{logarithm base for entropy calculation (default: 2)}

\item{...}{additional parameters}
}
\value{
A numeric matrix or value
}
\description{
Functions to compute uncertainty and variability measures for interval-valued data.
}
\details{
These functions measure uncertainty and variability:
\itemize{
  \item \code{int_entropy}: Shannon entropy (information content)
  \item \code{int_cv}: Coefficient of variation (CV = SD / Mean)
  \item \code{int_dispersion}: General dispersion index
  \item \code{int_imprecision}: Imprecision based on interval width
  \item \code{int_granularity}: Variability in interval sizes
}
}
\examples{
data(mushroom.int)

# Calculate entropy
int_entropy(mushroom.int, var_name = "Pileus.Cap.Width")

# Coefficient of variation
int_cv(mushroom.int, var_name = c("Stipe.Length", "Stipe.Thickness"), method = c("CM", "EJD"))

# Measure imprecision
int_imprecision(mushroom.int, var_name = c("Stipe.Length", "Stipe.Thickness"))

# Check data granularity
int_granularity(mushroom.int, var_name = 2:4)
}
\seealso{
int_var int_entropy int_cv
}
\author{
Han-Ming Wu
}
