% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/same_shape.R
\name{same_shape}
\alias{same_shape}
\title{Give same shape}
\usage{
same_shape(data_set, reference_set, verbose = TRUE)
}
\arguments{
\item{data_set}{Matrix, data.frame or data.table to transform}

\item{reference_set}{Matrix, data.frame or data.table}

\item{verbose}{Should the algorithm talk? (logical, default to TRUE)}
}
\value{
Return \code{data_set} transformed in order to make it have the same shape as
\code{reference_set}
}
\description{
Transform \code{data_set} into the same shape as \code{reference_set}. Especially this
function will be useful to make your test set have the same shape as your train set.
}
\details{
This function will make sure that \code{data_set} and \code{reference_set}
\itemize{
   \item have the same class
   \item have exactly the same columns
   \item have columns with exactly the same class
   \item have factor factor with exactly the same levels
}
You should always use this function before applying your model on a new data set to make sure
that everything will go smoothly. But if this function change a lot of stuff you should have a
look to your preparation process, there might be something wrong.
}
\examples{
\dontrun{
# Build a train and a test
data(tiny_messy_adult)
data(adult)
train <- messy_adult
test <- adult # So test will have missing columns

# Prepare them
train <- prepare_set(train, verbose = FALSE, key = "country")
test <- prepare_set(test, verbose = FALSE, key = "country")

# Give them the same shape
test <- same_shape(test, train)
# As one can see in log, a lot of small change had to be done.
# This is an extreme case but you get the idea.
}
# "##NOT RUN:" mean that this example hasn't been run on CRAN since its long. But you can run it!
}
