% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/exposure-APIs-batch.R
\name{get_production_volume_batch}
\alias{get_production_volume_batch}
\title{Get Production Volume data via batch}
\usage{
get_production_volume_batch(
  DTXSID = NULL,
  API_key = NULL,
  rate_limit = 0L,
  Server = "https://comptox.epa.gov/ctx-api/exposure",
  verbose = FALSE
)
}
\arguments{
\item{DTXSID}{Chemical identifier DTXSID}

\item{API_key}{The user-specific API key}

\item{rate_limit}{Number of seconds to wait between requests}

\item{Server}{The root address for the API endpoint.}

\item{verbose}{A logical indicating if some "progress report" should be
given.}
}
\value{
A list of data.frames of production volume data corresponding to the
input DTXSIDs.
}
\description{
Get Production Volume data via batch
}
\examples{
\dontshow{if (FALSE) withAutoprint(\{ # examplesIf}
# Retrieve production volume data for BPA and Caffeine
get_production_volume_batch(DTXSID = c('DTXSID7020182', 'DTXSID0020232'))
\dontshow{\}) # examplesIf}
}
