% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cto_dataset_download.R
\name{cto_dataset_download}
\alias{cto_dataset_download}
\title{Download SurveyCTO Server Datasets}
\usage{
cto_dataset_download(id = NULL, dir = getwd(), overwrite = FALSE)
}
\arguments{
\item{id}{A character vector of dataset IDs to download.
If \code{NULL} (the default), the function queries the server for a list of all
available datasets and downloads them all.}

\item{dir}{A string specifying the directory where CSV files will be saved.
Defaults to the current working directory.}

\item{overwrite}{Logical. If \code{TRUE}, existing files in \code{dir} will be
overwritten. If \code{FALSE} (the default), existing files are skipped to conserve
bandwidth.}
}
\value{
(Invisibly) A character vector of file paths to the successfully
downloaded CSVs. Returns \code{NULL} if no datasets were found.
}
\description{
Downloads one or more datasets from a SurveyCTO server to a local directory
as CSV files.
}
\details{
\itemize{
\item \strong{Smart Downloading:} If \code{overwrite = FALSE}, the function checks if the
target file already exists in \code{dir} and skips the download.
\item \strong{Error Handling:} If a specific dataset fails to download, a warning is printed with the dataset name, but the function
continues processing the remaining list.
}
}
\examples{
\dontrun{
# --- Example 1: Download a specific dataset ---
paths <- cto_dataset_download(id = "household_data", dir = tempdir())
df <- read.csv(paths[1])

# --- Example 2: Download all datasets, skip existing files ---
paths <- cto_dataset_download(dir = "my_data_folder", overwrite = FALSE)
}
}
\seealso{
Other Dataset Management Functions: 
\code{\link{cto_dataset_create}()},
\code{\link{cto_dataset_delete}()},
\code{\link{cto_dataset_info}()},
\code{\link{cto_dataset_list}()}
}
\concept{Dataset Management Functions}
