% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/officer.R
\name{body_add_table_section}
\alias{body_add_table_section}
\title{Add a section with a table and its legend}
\usage{
body_add_table_section(
  doc,
  x,
  legend,
  ...,
  bookmark = NULL,
  title = getOption("crosstable_section_title", TRUE),
  title_lvl = getOption("crosstable_section_title_level", 3),
  sentence = getOption("crosstable_section_sentence", FALSE)
)
}
\arguments{
\item{doc}{a \code{rdocx} object}

\item{x}{a table: \code{crosstable}, \code{flextable}, or plain old \code{dataframe}}

\item{legend}{the legend to use}

\item{...}{passed on to \code{\link[flextable:body_add_flextable]{flextable::body_add_flextable()}} or \code{\link[=body_add_crosstable]{body_add_crosstable()}}}

\item{bookmark}{the bookmark to use. Defaults to the cleaned variable name of \code{x}}

\item{title}{the title to add for the section. Can also be \code{FALSE} (no title) or \code{TRUE} (the title defaults to \code{legend})}

\item{title_lvl}{the title level if applicable}

\item{sentence}{a sentence to add between the title (if applicable) and the table. If \code{TRUE}, defaults to \code{"Information about {tolower(title)} is described in Table @ref({bookmark})"}.}
}
\value{
The \code{docx} object \code{doc}
}
\description{
Add a section with a table and its legend
}
\examples{
library(officer)
read_docx() \%>\%
  body_add_title("Description", 1) \%>\%
  body_add_title("Population A", 2) \%>\%
  body_add_table_section(head(iris), "The iris dataset", sentence=TRUE) \%>\%
  body_add_table_section(crosstable(iris), "A crosstable of the iris dataset",
                         title=FALSE, sentence=TRUE, body_fontsize=8) \%>\%
  write_and_open()
}
