% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/officer.R
\name{body_add_legend}
\alias{body_add_legend}
\alias{body_add_table_legend}
\alias{body_add_figure_legend}
\title{Add a legend to a table or a figure}
\usage{
body_add_table_legend(
  doc,
  legend,
  ...,
  bookmark = NULL,
  legend_style = getOption("crosstable_style_legend", doc$default_styles$paragraph),
  style = deprecated(),
  legend_prefix = NULL,
  name_format = NULL,
  legend_name = "Table",
  seqfield = "SEQ Table \\\\* Arabic",
  par_before = FALSE,
  envir = parent.frame(),
  legacy = FALSE
)

body_add_figure_legend(
  doc,
  legend,
  ...,
  bookmark = NULL,
  legend_style = getOption("crosstable_style_legend", doc$default_styles$paragraph),
  style = deprecated(),
  legend_prefix = NULL,
  name_format = NULL,
  legend_name = "Figure",
  seqfield = "SEQ Figure \\\\* Arabic",
  par_after = FALSE,
  envir = parent.frame(),
  legacy = FALSE
)
}
\arguments{
\item{doc}{a docx object}

\item{legend}{the table legend. Supports \code{glue} syntax and markdown syntax (see Section below).}

\item{...}{unused}

\item{bookmark}{the id of the bookmark. This is the id that should then be called in \code{\link[=body_add_normal]{body_add_normal()}} using the \code{"\\\\@ref(id)"} syntax. Forbidden characters will be removed.}

\item{legend_style}{style of of the whole legend. May depend on the docx template. However, if \code{name_format} is provided with a specific \code{font.size}, this size will apply to the whole legend for consistency.}

\item{style}{deprecated in favor of \code{name_format}.}

\item{legend_prefix}{a prefix that comes before the legend, after the numbering}

\item{name_format}{format of the legend's LHS (legend_name + numbering) using \code{\link[officer:fp_text]{officer::fp_text_lite()}} or \code{\link[officer:fp_text]{officer::fp_text()}}. Default to \code{fp_text_lite(bold=TRUE)} in addition to the format defined in \code{legend_style}. Note that the reference to the bookmark will have the same specific format in the text.}

\item{legend_name}{name before the numbering. Default to either "Table" or "Figure".}

\item{seqfield}{Keep default. Otherwise, you may figure it out doing this: in a docx file, insert a table legend, right click on the inserted number and select "Toggle Field Codes". This argument should be the value of the field, with extra escaping.}

\item{par_before, par_after}{should an empty paragraph be inserted before/after the legend?}

\item{envir}{Environment to evaluate each expression in \code{glue()}.}

\item{legacy}{use the old version of this function, if you cannot update \code{{officer}} to v0.4+}
}
\value{
The docx object \code{doc}
}
\description{
Add a legend to a table or a figure in an \code{officer} document. Legends can be referred to using the \verb{@ref} syntax in \code{\link[=body_add_normal]{body_add_normal()}} (see examples for some use cases). Table legends should be inserted before the table while figure legends should be inserted after the figure.
}
\section{Warning}{

Be aware that you unfortunately cannot reference a bookmark more than once using this method. Writing: \cr \code{body_add_normal("Table \\\\@ref(iris_col1) is about flowers. I really like Table \\\\@ref(iris_col1).")}\cr
will prevent the numbering from applying.
}

\section{What to do if there is still no numbering?}{

During the opening of the document, MS Word might ask you to "update the fields", to which you should answer "Yes".  \cr
If it is not asked or if you answer "No", the legends added with \code{\link[=body_add_table_legend]{body_add_table_legend()}} or \code{\link[=body_add_figure_legend]{body_add_figure_legend()}} might have no actual numbers displayed. \cr
In this case, you have to manually update the references in MS Word: select all (\kbd{Ctrl}+\kbd{A}), then update (\kbd{F9}), sometimes twice. More info on \url{https://ardata-fr.github.io/officeverse/faq.html#update-fields}.
}

\section{Markdown support}{

In all \code{crosstable} helpers for \code{officer}, you can use the following Markdown syntax to format your text:
\itemize{
\item \emph{bold}: \code{"**text in bold**"}
\item *italics: \code{"*text in italics*"}
\item \emph{subscript}: \code{"Text in ~subscript~"}
\item \emph{superscript}: \code{"Text in ^superscript^"}
\item \emph{newline}: \verb{Before <br> After}
\item \emph{color}: \code{"<color:red>red text</color>"}
\item \emph{shade}: \code{"<shade:yellow>yellow text</shade>"} (background color)
\item \emph{font family}: \code{"<ff:symbol>symbol</ff>"} (
}

Note that the font name depends on your system language. For instant, in French, it would be \code{Symbol} with an uppercase first letter.

See the last example of \code{\link[=body_add_normal]{body_add_normal()}} for a practical case.
}

\examples{
library(officer)
library(ggplot2)
p = ggplot(iris, aes(x=Sepal.Length, y=Sepal.Width, color=Species)) + geom_point()
fp_italic = fp_text_lite(italic=TRUE, font.size=10)
x = read_docx() \%>\%
    body_add_normal("There is Table \\\\@ref(iris_col1) and Table \\\\@ref(iris_col2). ",
                    "The `iris` dataset is about flowers.") \%>\%
    body_add_normal() \%>\%
    body_add_table_legend("Iris dataset, column 1 (mean={round(mean(iris[[1]]), 2)})",
                           bookmark="iris_col1") \%>\%
    body_add_crosstable(crosstable(iris[1])) \%>\%
    body_add_normal() \%>\%
    body_add_table_legend("Iris dataset, column 2 (mean={round(mean(iris[[2]]), 2)})",
                          bookmark="iris_col2",
                          name_format=fp_italic, legend_style="Balloon Text") \%>\%
    body_add_crosstable(crosstable(iris[2])) \%>\%
    body_add_normal() \%>\%
    body_add_normal("There is also the figure \\\\@ref(iris_fig)") \%>\%
    body_add_gg(p) \%>\%
    body_add_figure_legend("Iris plot", bookmark="iris_fig")
write_and_open(x)
#If asked to update fields, press "Yes". Otherwise press Ctrl+A then F9 twice for the references
#to appear.
}
\author{
Dan Chaltiel
}
