% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tbl_baseline_chg.R
\name{tbl_baseline_chg}
\alias{tbl_baseline_chg}
\alias{add_overall.tbl_baseline_chg}
\title{Change from Baseline}
\usage{
tbl_baseline_chg(
  data,
  baseline_level,
  denominator,
  by = NULL,
  digits = NULL,
  id = "USUBJID",
  visit = "AVISIT",
  visit_number = "AVISITN",
  analysis_variable = "AVAL",
  change_variable = "CHG"
)

\method{add_overall}{tbl_baseline_chg}(
  x,
  last = FALSE,
  col_label = "All Participants  \\n(N = {style_roche_number(n)})",
  ...
)
}
\arguments{
\item{data}{(\code{data.frame})\cr A data frame.}

\item{baseline_level}{(\code{string})\cr
String identifying baseline level in the \code{visit} variable.}

\item{denominator}{(\code{string})\cr
Data set used to compute the header counts (typically \code{ADSL}).}

\item{by}{(\code{\link[dplyr:dplyr_tidy_select]{tidy-select}})\cr
A single column from \code{data}. Summary statistics will be stratified by this variable.
Default is \code{NULL}.}

\item{digits}{(\code{\link[gtsummary:syntax]{formula-list-selector}})\cr
Specifies how summary statistics are rounded. Values may be either integer(s)
or function(s). If not specified, default formatting is assigned
via \code{assign_summary_digits()}. See below for details.}

\item{id}{(\code{string})\cr
String identifying the unique subjects. Default is \code{'USUBJID'}.}

\item{visit}{(\code{string})\cr
String for the visit variable. Default is
\code{'AVISIT'}. If there are more than one entry for each visit and subject,
only the first row is kept.}

\item{visit_number}{(\code{string})\cr
String identifying the visit or analysis sequence number. Default is
\code{'AVISITN'}.}

\item{analysis_variable}{(\code{string})\cr
String identifying the analysis values. Default is \code{'AVAL'}.}

\item{change_variable}{(\code{string})\cr
String identifying the change from baseline values. Default is \code{'CHG'}.}

\item{x}{(\code{tbl_summary}, \code{tbl_svysummary}, \code{tbl_continuous}, \code{tbl_custom_summary})\cr
A stratified 'gtsummary' table}

\item{last}{(scalar \code{logical})\cr
Logical indicator to display overall column last in table.
Default is \code{FALSE}, which will display overall column first.}

\item{col_label}{(\code{string})\cr
String indicating the column label. Default is \code{"**Overall**  \nN = {style_number(N)}"}}

\item{...}{These dots are for future extensions and must be empty.}
}
\value{
a gtsummary table
}
\description{
Typical use is tabulating changes from baseline
measurement of an Analysis Variable.
}
\examples{
\dontshow{if (identical(Sys.getenv("NOT_CRAN"), "true") || identical(Sys.getenv("IN_PKGDOWN"), "true")) withAutoprint(\{ # examplesIf}
theme_gtsummary_roche()

df <- cards::ADLB |>
  dplyr::mutate(AVISIT = trimws(AVISIT)) |>
  dplyr::filter(
    AVISIT != "End of Treatment",
    PARAMCD == "SODIUM"
  )

tbl_baseline_chg(
  data = df,
  baseline_level = "Baseline",
  by = "TRTA",
  denominator = cards::ADSL
)

tbl_baseline_chg(
  data = df,
  baseline_level = "Baseline",
  by = "TRTA",
  denominator = cards::ADSL
) |>
  add_overall(last = TRUE, col_label = "All Participants")
\dontshow{\}) # examplesIf}
}
