% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/colocboost_output.R
\name{get_cos_summary}
\alias{get_cos_summary}
\title{Get colocalization summary table from a ColocBoost output.}
\source{
See detailed instructions in our tutorial portal:
\url{https://statfungen.github.io/colocboost/articles/Interpret_ColocBoost_Output.html}
}
\usage{
get_cos_summary(
  cb_output,
  outcome_names = NULL,
  interest_outcome = NULL,
  region_name = NULL
)
}
\arguments{
\item{cb_output}{Output object from \code{colocboost} analysis}

\item{outcome_names}{Optional vector of names of outcomes, which has the same order as Y in the original analysis.}

\item{interest_outcome}{Optional vector specifying a subset of outcomes from \code{outcome_names} to focus on. When provided, only colocalization events that include at least one of these outcomes will be returned.}

\item{region_name}{Optional character string. When provided, adds a column with this gene name to the output table for easier filtering in downstream analyses.}
}
\value{
A summary table for colocalization events with the following columns:
\item{focal_outcome}{The focal outcome being analyzed if exists. Otherwise, it is \code{FALSE}.}
\item{colocalized_outcomes}{Colocalized outcomes for colocalization confidence set (CoS) }
\item{cos_id}{Unique identifier for colocalization confidence set (CoS) }
\item{purity}{Minimum absolute correlation of variables with in colocalization confidence set (CoS) }
\item{top_variable}{The variable with highest variant colocalization probability (VCP) }
\item{top_variable_vcp}{Variant colocalization probability for the top variable}
\item{cos_npc}{Normalized probability of colocalization}
\item{min_npc_outcome}{Minimum normalized probability of colocalized traits}
\item{n_variables}{Number of variables in colocalization confidence set (CoS)}
\item{colocalized_index}{Indices of colocalized variables}
\item{colocalized_variables}{List of colocalized variables}
\item{colocalized_variables_vcp}{Variant colocalization probabilities for all colocalized variables}
}
\description{
\code{get_cos_summary} get the colocalization summary table with or without the outcomes of interest.
}
\examples{
# colocboost example
set.seed(1)
N <- 1000
P <- 100
# Generate X with LD structure
sigma <- 0.9^abs(outer(1:P, 1:P, "-"))
X <- MASS::mvrnorm(N, rep(0, P), sigma)
colnames(X) <- paste0("SNP", 1:P)
L <- 3
true_beta <- matrix(0, P, L)
true_beta[10, 1] <- 0.5 # SNP10 affects trait 1
true_beta[10, 2] <- 0.4 # SNP10 also affects trait 2 (colocalized)
true_beta[50, 2] <- 0.3 # SNP50 only affects trait 2
true_beta[80, 3] <- 0.6 # SNP80 only affects trait 3
Y <- matrix(0, N, L)
for (l in 1:L) {
  Y[, l] <- X \%*\% true_beta[, l] + rnorm(N, 0, 1)
}
res <- colocboost(X = X, Y = Y)
get_cos_summary(res)

}
\seealso{
Other colocboost_utilities: 
\code{\link{get_cormat}()},
\code{\link{get_cos}()},
\code{\link{get_cos_purity}()},
\code{\link{get_hierarchical_clusters}()},
\code{\link{get_ucos_summary}()}
}
\concept{colocboost_utilities}
\keyword{colocboost_inference}
