% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/reporting.R
\name{reportNPAV}
\alias{reportNPAV}
\title{Generate the Latex-text based on the NPAV by Lüpsen (see \url{https://www.uni-koeln.de/~luepsen/R/}).
Only significant main and interaction effects are reported.
P-values are rounded for the third digit and partial eta squared values are provided when possible.
Attention: the independent variables of the formula and the term specifying the participant must be factors (i.e., use as.factor()).}
\usage{
reportNPAV(model, dv = "Testdependentvariable", write_to_clipboard = FALSE)
}
\arguments{
\item{model}{the model of the np.anova}

\item{dv}{the name of the dependent variable that should be reported}

\item{write_to_clipboard}{whether to write to the clipboard}
}
\value{
A message describing the statistical results.
}
\description{
To easily copy and paste the results to your manuscript, the following commands must be defined in Latex:
\code{\\newcommand{\\F}[3]{$F({#1},{#2})={#3}$}}
\code{\\newcommand{\\p}{\\textit{p=}}}
\code{\\newcommand{\\pminor}{\\textit{p$<$}}}
}
\examples{
model <- data.frame(
  Df = c(1, 1, 10),
  `F value` = c(6.12, 5.01, NA),
  `Pr(>F)` = c(0.033, 0.045, NA),
  check.names = FALSE
)
rownames(model) <- c("Video", "gesture:eHMI", "Residuals")
reportNPAV(model, dv = "mental workload")
}
