% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/reporting.R
\name{reportDunnTest}
\alias{reportDunnTest}
\title{Report dunnTest as text. Required commands in LaTeX:
\code{\\newcommand{\\padjminor}{\\textit{p$_{adj}<$}}}
\code{\\newcommand{\\padj}{\\textit{p$_{adj}$=}}}
\code{\\newcommand{\\rankbiserial}[1]{$r_{rb} = #1$}}}
\usage{
reportDunnTest(d, data, iv = "testiv", dv = "testdv")
}
\arguments{
\item{d}{the dunn test object}

\item{data}{the data frame}

\item{iv}{independent variable}

\item{dv}{dependent variable}
}
\value{
A message describing the statistical results.
}
\description{
Report dunnTest as text. Required commands in LaTeX:
\code{\\newcommand{\\padjminor}{\\textit{p$_{adj}<$}}}
\code{\\newcommand{\\padj}{\\textit{p$_{adj}$=}}}
\code{\\newcommand{\\rankbiserial}[1]{$r_{rb} = #1$}}
}
\examples{
\donttest{
if (requireNamespace("FSA", quietly = TRUE)) {
  # Use built-in iris data
  data(iris)

  # Dunn test on Sepal.Length by Species
  d <- FSA::dunnTest(Sepal.Length ~ Species,
    data   = iris,
    method = "holm"
  )

  # Report the Dunn test
  reportDunnTest(d,
    data = iris,
    iv   = "Species",
    dv   = "Sepal.Length"
  )
}
}
}
