% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils.R
\name{remove_outliers_REI}
\alias{remove_outliers_REI}
\title{Remove outliers and calculate REI}
\usage{
remove_outliers_REI(df, header = FALSE, variables = "", range = c(1, 5))
}
\arguments{
\item{df}{Data frame containing the data.}

\item{header}{Logical indicating if the data frame has a header. Defaults to FALSE.}

\item{variables}{Character string specifying which variables to consider, separated by commas.}

\item{range}{Numeric vector specifying the range of the Likert scale. Defaults to c(1, 5).}
}
\value{
A data frame with calculated REI, percentile, and a 'Suspicious' flag.
}
\description{
This function takes a data frame, optional header information, variables to consider,
and a range for a Likert scale. It then calculates the Response Entropy Index (REI)
and flags suspicious entries based on percentiles.
}
\details{
For more information on the REI method, refer to:
\href{https://ojs.ub.uni-konstanz.de/srm/article/view/7832}{Response Entropy Index Method}
}
\examples{
\donttest{
df <- data.frame(var1 = c(1, 2, 3), var2 = c(2, 3, 4))
result <- remove_outliers_REI(df, TRUE, "var1,var2", c(1, 5))
}
}
