% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils.R
\name{add_pareto_emoa_column}
\alias{add_pareto_emoa_column}
\title{Add Pareto EMOA Column to a Data Frame}
\usage{
add_pareto_emoa_column(data, objectives)
}
\arguments{
\item{data}{A data frame containing the data, including the objective columns.}

\item{objectives}{A character vector specifying the names of the objective columns in \code{data}. These columns should be numeric and will be used to calculate the Pareto front.}
}
\value{
A data frame with the same columns as \code{data}, along with an additional column, \code{PARETO_EMOA}, which is \code{TRUE} for rows that are on the Pareto front and \code{FALSE} otherwise.
}
\description{
This function calculates the Pareto front for a given set of objectives in a data frame and adds a new column, \code{PARETO_EMOA}, which indicates whether each row in the data frame belongs to the Pareto front.
}
\examples{
# Define objective columns
objectives <- c("trust", "predictability", "perceivedSafety", "Comfort")

# Example data frame
main_df <- data.frame(
  trust = runif(10),
  predictability = runif(10),
  perceivedSafety = runif(10),
  Comfort = runif(10)
)

# Add the Pareto front column
main_df <- add_pareto_emoa_column(data = main_df, objectives)
head(main_df)
}
