% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/format_statvalues.R
\name{format_p}
\alias{format_p}
\title{Format p-values}
\usage{
format_p(
  x,
  digits = 3,
  pzero = FALSE,
  label = "p",
  italics = TRUE,
  type = "md"
)
}
\arguments{
\item{x}{Number representing p-value.}

\item{digits}{Number of digits after the decimal for p-values, ranging
between 1-5 (also controls cutoff for small p-values).}

\item{pzero}{Logical value (default = FALSE) for whether to include leading
zero for p-values.}

\item{label}{Character string for label before p value. Default is p.
Set \code{label = ""} to return just the formatted p value with no
label or operator (\code{=}, \code{<}, \code{>}).}

\item{italics}{Logical value (default = TRUE) for whether label should be
italicized (\emph{p}).}

\item{type}{Type of formatting ("md" = markdown, "latex" = LaTeX).}
}
\value{
A character string that includes \emph{p} and then the p-value formatted in
Markdown or LaTeX. If p-value is below \code{digits} cutoff, \code{p < cutoff} is
used.
}
\description{
\code{format_p()} inputs numeric vectors of p-values. Cutoffs can be set that
format the values as less than the cutoffs (e.g., p < 0.001). The default
output is APA formatted, but numbers of digits, cutoffs, leading zeros, and
italics are all customizable.
}
\examples{
# Format p-value
format_p(0.001)

# Format p-value vector
format_p(c(0.001, 0.01))

# Round digits for p-values greater than cutoff
format_p(0.111, digits = 2)

# Default cutoff is p < 0.001
format_p(0.0001)

# Set cutoff with digits
format_p(0.0001, digits = 2)

# Include leading zero
format_p(0.001, pzero = TRUE)

# Return only Bayes factor value (no label)
format_p(0.001, label = "")

# Format for LaTeX
format_p(0.001, type = "latex")
}
