% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/link_cdfs.R
\name{loggamma_cdf}
\alias{loggamma_cdf}
\title{Log-gamma link CDF}
\usage{
loggamma_cdf(x, lambda)
}
\arguments{
\item{x}{Numeric vector}

\item{lambda}{Shape parameter}
}
\value{
CDF values
}
\description{
Based on the log-gamma distribution:
\itemize{
\item lambda = 0: probit (normal)
\item lambda > 0: F(x) = pgamma(exp(x), shape = lambda, rate = lambda)
\item lambda < 0: F(x) = 1 - pgamma(exp(-x), shape = -lambda, rate = -lambda)
}
}
\details{
Reference: Prentice (1976) Biometrics
}
\keyword{internal}
