% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/methods.R
\name{diagnostics}
\alias{diagnostics}
\alias{diagnostics.clmstan}
\title{MCMC Diagnostics for clmstan objects}
\usage{
diagnostics(object, ...)

\method{diagnostics}{clmstan}(
  object,
  detail = FALSE,
  rhat_threshold = 1.01,
  ess_threshold = 400,
  ...
)
}
\arguments{
\item{object}{A clmstan object}

\item{...}{Additional arguments (ignored)}

\item{detail}{Logical. If TRUE, show full parameter-level diagnostics table.
If FALSE (default), show only summary and any problematic parameters.}

\item{rhat_threshold}{Threshold for flagging high Rhat values. Default 1.01.}

\item{ess_threshold}{Threshold for flagging low ESS values. Default 400.}
}
\value{
Invisibly returns a list containing:
\itemize{
\item hmc: HMC diagnostics from CmdStanMCMC$diagnostic_summary()
\item convergence: Data frame of per-parameter Rhat and ESS values
\item issues: Logical indicating whether any issues were detected
}
}
\description{
Provides a summary of MCMC convergence diagnostics including HMC-specific
diagnostics (divergences, treedepth, E-BFMI) and general convergence
measures (Rhat, ESS).
}
\details{
The function checks for the following issues:
\itemize{
\item \strong{Divergences}: Number of divergent transitions (ideally 0)
\item \strong{Treedepth}: Transitions hitting max treedepth (efficiency issue)
\item \strong{E-BFMI}: Energy Bayesian Fraction of Missing Information
(values < 0.3 indicate problems)
\item \strong{Rhat}: Potential scale reduction factor (values > 1.01
indicate lack of convergence)
\item \strong{ESS}: Effective sample size for bulk and tail
(low values indicate high autocorrelation)
}
}
\examples{
\dontrun{
fit <- clm_stan(rating ~ temp, data = wine)
diagnostics(fit)
diagnostics(fit, detail = TRUE)
}

}
