\name{rome_iv_functional_defecation_disorders}
\alias{rome_iv_functional_defecation_disorders}
\title{
Rome IV Diagnostic Criteria for Functional Defecation Disorders
}
\description{
Evaluates the Rome IV criteria for diagnosing Functional Defecation Disorders (FDD). These disorders are characterized by a set of defecatory symptoms (straining, incomplete evacuation, etc.) along with objective evidence of impaired defecatory dynamics on anorectal function testing (e.g., manometry or balloon expulsion). The diagnosis requires at least two out of four core symptoms, objective testing evidence, and exclusion of organic causes.
}
\usage{
rome_iv_functional_defecation_disorders(straining_ge_25_percent,
                                        sensation_incomplete_evacuation_ge_25_percent,
                                        sensation_anorectal_blockage_ge_25_percent,
                                        manual_maneuver_ge_25_percent,
                                        inadequate_defecatory_propulsion,
                                        dyssynergic_defecation, other_conditions_excluded)
}
\arguments{
  \item{straining_ge_25_percent}{
Numeric (0 or 1). Straining during at least 25\% of defecations. (1 = Yes).
}
  \item{sensation_incomplete_evacuation_ge_25_percent}{
Numeric (0 or 1). Sensation of incomplete evacuation in at least 25\% of defecations. (1 = Yes).
}
  \item{sensation_anorectal_blockage_ge_25_percent}{
Numeric (0 or 1). Sensation of anorectal obstruction/blockage in at least 25\% of defecations. (1 = Yes).
}
  \item{manual_maneuver_ge_25_percent}{
Numeric (0 or 1). Use of manual maneuvers to facilitate at least 25\% of defecations. (1 = Yes).
}
  \item{inadequate_defecatory_propulsion}{
Numeric (0 or 1). Objective evidence of impaired propulsion (e.g., ineffective pushing phase on manometry). (1 = Yes).
}
  \item{dyssynergic_defecation}{
Numeric (0 or 1). Objective evidence of dyssynergia (e.g., paradoxical puborectalis contraction or inadequate relaxation). (1 = Yes).
}
  \item{other_conditions_excluded}{
Numeric (0 or 1). Organic causes for the symptoms excluded (e.g., neoplasm, IBS). (1 = Yes).
}
}
\value{
A list containing:
\item{Diagnosis}{The resulting FDD subtype (Inadequate Defecatory Propulsion, Dyssynergic Defecation, or General FDD).}
}
\references{
Rao SS, Bharucha AE, Chiarioni G, et al. Anorectal Disorders. Gastroenterology. 2016;150:1430-1442. doi:10.1053/j.gastro.2016.02.009
}
\examples{

# Example 1: Dyssynergic Defecation
# Two symptoms met (Q1, Q3), Dyssynergia confirmed by testing
rome_iv_functional_defecation_disorders(1, 0, 1, 0, 0, 1, 1)

# Example 2: Inadequate Defecatory Propulsion
# Three symptoms met, Propulsion inadequacy confirmed
rome_iv_functional_defecation_disorders(1, 1, 1, 0, 1, 0, 1)
}
