\name{pittsburgh_knee_rules}
\alias{pittsburgh_knee_rules}
\title{
Pittsburgh Knee Rules
}
\description{
Applies the Pittsburgh Knee Rules to determine the need for knee radiography in patients with acute knee injury. This decision rule is highly sensitive for detecting knee fractures and can reduce unnecessary imaging.
}
\usage{
pittsburgh_knee_rules(blunt_trauma_or_fall, age_years, unable_to_walk_4_steps_in_ed)
}
\arguments{
  \item{blunt_trauma_or_fall}{
Numeric (0 or 1). Did the injury involve blunt trauma or a fall? (1 = Yes). This is the entry criterion for the rule.
}
  \item{age_years}{
Numeric. Patient age in years.
}
  \item{unable_to_walk_4_steps_in_ed}{
Numeric (0 or 1). Is the patient unable to walk 4 weight-bearing steps in the emergency department? (1 = Yes).
}
}
\details{
Imaging is indicated if the mechanism is blunt trauma or fall AND one of the following is met:
\itemize{
  \item Age < 12 years
  \item Age > 50 years
  \item Inability to walk 4 weight-bearing steps in the ED
}
}
\value{
A list containing:
\item{Recommendation}{Guidance on whether a knee X-ray is indicated.}
}
\references{
Seaberg DC, Yealy DM, Lukens T, Auble T, Mathiasen RA. Multicenter comparison of two clinical decision rules for the use of radiography in acute, high-risk knee injuries. Ann Emerg Med. 1998;32(1):8-13. doi:10.1016/s0196-0644(98)70094-4
}
\examples{

# Example 1: X-ray Indicated (Age)
# Trauma (1), Age 60, Can walk (0)
pittsburgh_knee_rules(1, 60, 0)

# Example 2: X-ray Indicated (Inability to walk)
# Trauma (1), Age 30, Cannot walk (1)
pittsburgh_knee_rules(1, 30, 1)

# Example 3: Not Indicated
# Trauma (1), Age 30, Can walk (0)
pittsburgh_knee_rules(1, 30, 0)
}
