\name{manchester_sclc_score}
\alias{manchester_sclc_score}
\title{
Manchester Score for Prognosis in Small Cell Lung Cancer (SCLC)
}
\description{
Calculates the Manchester Score to predict prognosis in patients with Small Cell Lung Cancer (SCLC). The score stratifies patients into Good, Intermediate, or Poor risk groups based on LDH, Sodium, Alkaline Phosphatase, Karnofsky Performance Status, Bicarbonate, and Disease Stage.
}
\usage{
manchester_sclc_score(ldh_level, ldh_uln, sodium, alk_phos_level, alk_phos_uln,
                      kps, bicarbonate, stage_extensive)
}
\arguments{
  \item{ldh_level}{
Numeric. Patient's serum Lactate Dehydrogenase level (U/L).
}
  \item{ldh_uln}{
Numeric. Laboratory Upper Limit of Normal for LDH. (Score adds 1 if LDH >= ULN).
}
  \item{sodium}{
Numeric. Serum Sodium level (mmol/L or mEq/L). (Score adds 1 if Na < 132).
}
  \item{alk_phos_level}{
Numeric. Serum Alkaline Phosphatase level (U/L).
}
  \item{alk_phos_uln}{
Numeric. Laboratory Upper Limit of Normal for Alkaline Phosphatase. (Score adds 1 if ALP >= 1.5x ULN).
}
  \item{kps}{
Numeric. Karnofsky Performance Status score (0-100). (Score adds 1 if KPS < 60).
}
  \item{bicarbonate}{
Numeric. Serum Bicarbonate (HCO3) level (mmol/L or mEq/L). (Score adds 1 if HCO3 < 24).
}
  \item{stage_extensive}{
Numeric (0 or 1). Is the disease stage Extensive? (1 = Yes, +1 point; 0 = Limited, 0 points).
}
}
\value{
A list containing:
\item{Manchester_Score}{The calculated total score (Range 0-6).}
\item{Prognosis_Group}{Classification (Good 0-1, Intermediate 2-3, Poor 4-6).}
\item{Median_Survival}{Estimated median survival time.}
\item{Two_Year_Survival}{Estimated 2-year survival percentage.}
}
\references{
Cerny T, Blair V, Anderson H, et al. Pretreatment prognostic factors and scoring system in 407 small-cell lung cancer patients. Int J Cancer. 1987;39(2):146-149. doi:10.1002/ijc.2910390204
}
\examples{

# Example 1: Good Prognosis
# Normal labs, High KPS, Limited Stage
manchester_sclc_score(150, 250, 140, 80, 120, 90, 26, 0)

# Example 2: Poor Prognosis
# High LDH, Low Na, High ALP, Low KPS, Low HCO3, Extensive Stage
# Score = 6
manchester_sclc_score(300, 250, 130, 200, 100, 50, 20, 1)
}
