\name{embed_buprenorphine_initiation}
\alias{embed_buprenorphine_initiation}
\title{
EMBED Buprenorphine Initiation Decision Support
}
\description{
Provides clinical decision support for initiating buprenorphine in the Emergency Department for patients with Opioid Use Disorder (OUD). The algorithm evaluates OUD diagnosis, treatment readiness, withdrawal severity (COWS score), pregnancy status, and provider waiver status to recommend appropriate actions (initiation, home induction, or referral).
}
\usage{
embed_buprenorphine_initiation(oud_present, treatment_readiness,
                               withdrawal_severity_cows, pregnant, waiver_status)
}
\arguments{
  \item{oud_present}{
Numeric (0 or 1). Does the patient meet DSM-5 criteria for Opioid Use Disorder? (1 = Yes).
}
  \item{treatment_readiness}{
Numeric (0 or 1). Is the patient ready to start treatment today? (1 = Yes).
}
  \item{withdrawal_severity_cows}{
Numeric. The patient's Clinical Opiate Withdrawal Scale (COWS) score.
}
  \item{pregnant}{
Numeric (0 or 1). Is the patient pregnant? (1 = Yes).
}
  \item{waiver_status}{
Numeric (0 or 1). Does the provider have a waiver (X-waiver) to prescribe buprenorphine? (1 = Yes). Note: Recent US legislation removed the X-waiver requirement, but local protocols may vary.
}
}
\value{
A list containing:
\item{Recommendation}{Clinical guidance on whether to initiate, observe, or refer.}
}
\references{
Melnick ER, et al. User-centered clinical decision support to implement initiation of buprenorphine for opioid use disorder in the emergency department: EMBED pragmatic cluster randomized controlled trial. BMJ. 2022;377:e069271.
}
\examples{

# Example 1: Ready for Induction
# OUD Yes, Ready Yes, COWS 10 (Moderate), Not Pregnant, Waiver Yes
embed_buprenorphine_initiation(1, 1, 10, 0, 1)

# Example 2: Precipitated Withdrawal Risk
# OUD Yes, Ready Yes, COWS 4 (Mild), Not Pregnant, Waiver Yes
embed_buprenorphine_initiation(1, 1, 4, 0, 1)
}
