\name{diabetes_distress_scale}
\alias{diabetes_distress_scale}
\title{
Diabetes Distress Scale (DDS-17)
}
\description{
Calculates the total mean score and four subscale scores for the Diabetes Distress Scale (DDS-17). This 17-item instrument assesses the emotional burden and distress associated with diabetes management. Scores are categorized as little/no distress (<2.0), moderate distress (2.0-2.9), or high distress (>=3.0).
}
\usage{
diabetes_distress_scale(q1, q2, q3, q4, q5, q6, q7, q8, q9, q10, q11, q12,
                        q13, q14, q15, q16, q17)
}
\arguments{
  \item{q1}{Numeric (1-6). Feeling that diabetes is taking up too much of my mental and physical energy every day.}
  \item{q2}{Numeric (1-6). Feeling that my doctor doesn't know enough about diabetes and diabetes care.}
  \item{q3}{Numeric (1-6). Feeling angry, scared, and/or depressed when I think about living with diabetes.}
  \item{q4}{Numeric (1-6). Feeling that my doctor doesn't give me clear enough directions on how to manage my diabetes.}
  \item{q5}{Numeric (1-6). Feeling that I am not testing my blood sugars frequently enough.}
  \item{q6}{Numeric (1-6). Feeling that I am often failing with my diabetes routine.}
  \item{q7}{Numeric (1-6). Friends or family are not supportive enough of self-care efforts (e.g. planning activities that conflict with my schedule, encouraging me to eat the "wrong" foods).}
  \item{q8}{Numeric (1-6). Feeling that diabetes controls my life.}
  \item{q9}{Numeric (1-6). Feeling that my doctor doesn't take my concerns seriously enough.}
  \item{q10}{Numeric (1-6). Not feeling confident in my day-to-day ability to manage diabetes.}
  \item{q11}{Numeric (1-6). Feeling that I will end up with serious long-term complications, no matter what I do.}
  \item{q12}{Numeric (1-6). Feeling that I am not sticking closely enough to a good meal plan.}
  \item{q13}{Numeric (1-6). Friends or family don't appreciate how difficult living with diabetes can be.}
  \item{q14}{Numeric (1-6). Feeling overwhelmed by the demands of living with diabetes.}
  \item{q15}{Numeric (1-6). Feeling that I don't have a doctor who I can see regularly enough about my diabetes.}
  \item{q16}{Numeric (1-6). Not feeling motivated to keep up my diabetes self management.}
  \item{q17}{Numeric (1-6). Friends or family act like "diabetes police" (e.g. asking "did you eat that?" or "did you take your medicine?").}
}
\details{
\strong{Scoring Key:}
1: Not a problem
2: A slight problem
3: A moderate problem
4: Somewhat serious problem
5: A serious problem
6: A very serious problem

\strong{Subscales:}
- Emotional Burden: Q1, Q3, Q8, Q11, Q14
- Physician-related Distress: Q2, Q4, Q9, Q15
- Regimen-related Distress: Q5, Q6, Q10, Q12, Q16
- Interpersonal Distress: Q7, Q13, Q17
}
\value{
A list containing:
\item{Total_Mean_Score}{The average of all 17 items.}
\item{Total_Interpretation}{Clinical interpretation of the total score.}
\item{Subscales}{A list containing the mean scores and interpretations for each of the four domains.}
}
\references{
Polonsky WH, Fisher L, Earles J, et al. Assessing psychosocial distress in diabetes: development of the diabetes distress scale. Diabetes Care. 2005;28(3):626-631. doi:10.2337/diacare.28.3.626
}
\examples{

# Example 1: Moderate Distress
# All items scored 3 (Moderate problem)
# Result: Mean 3.0 (High Distress)
diabetes_distress_scale(3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3)

# Example 2: Mixed Profile
# Emotional items 5 (High), others 1 (Low)
diabetes_distress_scale(5, 1, 5, 1, 1, 1, 1, 5, 1, 1, 5, 1, 1, 5, 1, 1, 1)
}
