\name{bhutani_nomogram_risk}
\alias{bhutani_nomogram_risk}
\title{
Hour-Specific Risk for Neonatal Hyperbilirubinemia (Bhutani Nomogram)
}
\description{
Calculates the risk zone for neonatal hyperbilirubinemia based on the Bhutani Nomogram. This tool assesses the risk of developing severe hyperbilirubinemia in infants >= 35 weeks gestational age and birth weight >= 2000g or >= 2500g depending on specific guideline versions. It uses postnatal age in hours and Total Serum Bilirubin (TSB) to stratify infants into Low, Low-Intermediate, High-Intermediate, or High Risk zones.
}
\usage{
bhutani_nomogram_risk(age_hours, total_bilirubin, units = "mg/dL")
}
\arguments{
  \item{age_hours}{
Numeric. Postnatal age of the infant in hours. (Valid range typically 12-144+ hours).
}
  \item{total_bilirubin}{
Numeric. Total Serum Bilirubin level.
}
  \item{units}{
String. Units for the bilirubin input. Options: "mg/dL" (default) or "umol/L".
}
}
\value{
A list containing:
\item{Risk_Zone}{The determined risk category (e.g., "High Intermediate Risk Zone").}
\item{TSB_mg_dL}{The patient's bilirubin standardized to mg/dL.}
\item{Thresholds_at_Hour}{The calculated 40th, 75th, and 95th percentile bilirubin values for the specific hour provided.}
}
\references{
Bhutani VK, Johnson L, Sivieri EM. Predictive ability of a predischarge hour-specific serum bilirubin for subsequent significant hyperbilirubinemia in healthy term and near-term newborns. Pediatrics. 1999;103(1):6-14. doi:10.1542/peds.103.1.6
}
\examples{

# Example 1: High Risk
# 24 hours old, Bilirubin 9.0 mg/dL (High Risk starts > ~8.0)
bhutani_nomogram_risk(24, 9.0)

# Example 2: Low Risk
# 48 hours old, Bilirubin 6.0 mg/dL (< 40th percentile of ~9.3)
bhutani_nomogram_risk(48, 6.0)
}
