% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cdisc_validate.R
\name{validate_adam}
\alias{validate_adam}
\title{Validate ADaM Compliance}
\usage{
validate_adam(df, domain)
}
\arguments{
\item{df}{A data frame to validate.}

\item{domain}{Character string specifying the ADaM dataset name (e.g., "ADSL", "ADAE").}
}
\value{
A data frame with validation results containing columns:
\item{category}{Character: validation issue type}
\item{variable}{Character: variable name}
\item{message}{Character: issue description}
\item{severity}{Character: "ERROR", "WARNING", or "INFO"}
}
\description{
Validates a data frame against a specific ADaM dataset specification. Similar to
\code{\link[=validate_sdtm]{validate_sdtm()}} but uses ADaM metadata and treats Conditional variables differently.
}
\details{
Severity levels:
\itemize{
\item ERROR: Required variable is missing
\item WARNING: Data type mismatch detected
\item INFO: Conditional variable missing, non-standard variable, or variable information
}
}
\keyword{internal}
