% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/choice_probabilities.R
\name{choiceprob_probit}
\alias{choiceprob_probit}
\alias{choiceprob_mnp}
\alias{choiceprob_mnp_ordered}
\alias{choiceprob_mmnp}
\alias{choiceprob_mmnp_ordered}
\alias{choiceprob_mmnp_lc}
\alias{choiceprob_mmnp_ordered_lc}
\alias{choiceprob_mmnp_panel}
\alias{choiceprob_mmnp_ordered_panel}
\alias{choiceprob_mmnp_panel_lc}
\alias{choiceprob_mmnp_ordered_panel_lc}
\title{Calculate probit choice probabilities}
\usage{
choiceprob_probit(
  X,
  y = NULL,
  Tp = NULL,
  cml = "no",
  beta,
  Omega = NULL,
  Sigma,
  gamma = NULL,
  weights = NULL,
  re_position = utils::tail(seq_along(beta), nrow(Omega)),
  gcdf = pmvnorm_cdf_default,
  lower_bound = 0,
  input_checks = TRUE,
  ordered = !is.null(gamma),
  ranked = if (!ordered && !is.null(y) && isTRUE(length(y) > 0)) {
     length(y[[1]]) >
    1
 } else {
     FALSE
 },
  mixed = !is.null(Omega),
  panel = mixed & !is.null(Tp) & any(Tp > 1),
  lc = !is.null(weights)
)

choiceprob_mnp(
  X,
  y,
  beta,
  Sigma,
  gcdf = pmvnorm_cdf_default,
  lower_bound = 0,
  ranked = FALSE
)

choiceprob_mnp_ordered(X, y, beta, Sigma, gamma, lower_bound = 0)

choiceprob_mmnp(
  X,
  y,
  beta,
  Omega,
  Sigma,
  re_position = utils::tail(seq_along(beta), nrow(Omega)),
  gcdf = pmvnorm_cdf_default,
  lower_bound = 0,
  ranked = FALSE
)

choiceprob_mmnp_ordered(
  X,
  y,
  beta,
  Omega,
  Sigma,
  gamma,
  re_position = utils::tail(seq_along(beta), nrow(Omega)),
  lower_bound = 0
)

choiceprob_mmnp_lc(
  X,
  y,
  beta,
  Omega,
  Sigma,
  weights,
  re_position = utils::tail(seq_along(beta[[1]]), nrow(Omega[[1]])),
  gcdf = pmvnorm_cdf_default,
  lower_bound = 0,
  ranked = FALSE
)

choiceprob_mmnp_ordered_lc(
  X,
  y,
  beta,
  Omega,
  Sigma,
  gamma,
  weights,
  re_position = utils::tail(seq_along(beta[[1]]), nrow(Omega[[1]])),
  lower_bound = 0
)

choiceprob_mmnp_panel(
  X,
  y,
  Tp,
  cml,
  beta,
  Omega,
  Sigma,
  re_position = utils::tail(seq_along(beta), nrow(Omega)),
  gcdf = pmvnorm_cdf_default,
  lower_bound = 0,
  ranked = FALSE
)

choiceprob_mmnp_ordered_panel(
  X,
  y,
  Tp,
  cml,
  beta,
  Omega,
  Sigma,
  gamma,
  re_position = utils::tail(seq_along(beta), nrow(Omega)),
  gcdf = pmvnorm_cdf_default,
  lower_bound = 0
)

choiceprob_mmnp_panel_lc(
  X,
  y,
  Tp,
  cml,
  beta,
  Omega,
  Sigma,
  weights,
  re_position = utils::tail(seq_along(beta), nrow(Omega)),
  gcdf = pmvnorm_cdf_default,
  lower_bound = 0,
  ranked = FALSE
)

choiceprob_mmnp_ordered_panel_lc(
  X,
  y,
  Tp,
  cml,
  beta,
  Omega,
  Sigma,
  gamma,
  weights,
  re_position = utils::tail(seq_along(beta), nrow(Omega)),
  gcdf = pmvnorm_cdf_default,
  lower_bound = 0
)
}
\arguments{
\item{X}{[\code{list(N)}]\cr
A \code{list} of length \code{N} (number observations) of design matrices, each of
dimension \code{J} (number alternatives) times \code{P} (number effects).

In the ordered case (\code{ordered = TRUE}), the design matrices are of dimension
\code{1} times \code{P}.}

\item{y}{[\code{list(N)} | \code{NULL}]\cr
A \code{list} of length \code{N} (number observations) of single integers from \code{1} to
\code{J} (number alternatives).

In the ranked case (\code{ranked = TRUE}), the list entries each must be a
permutation of \code{1:J}, where the higher-ranked alternatives are in front.

In the non-panel case (\code{panel = FALSE}), \code{y} can also be \code{NULL}, in which
case probabilities are calculated for all choice alternatives.
In the ranked case (\code{ranked = TRUE}), if \code{y} is \code{NULL},
only first place choice probabilities are computed, which is equivalent to
computing choice probabilities in the regular (maximum utility) model.}

\item{Tp}{[\code{NULL} | \code{integer(N)}]\cr
The panel identifier of length \code{N} (number observations) for panel data.
The number \code{Tp[1]} indicates, that the first \code{Tp[1]} observations in \code{X} and
\code{y} belong to decider 1, the next \code{Tp[2]} observations belong to decider 2,
and so on.

Can be \code{NULL} for no panel data.}

\item{cml}{[\code{character(1)}]\cr
The composite marginal likelihood (CML) type for panel data. It can be one of
\code{"no"} (full likelihood), \code{"fp"} (full pairwise), or \code{"ap"} (adjacent
pairwise).}

\item{beta}{[\code{numeric(P)} | \code{list}]\cr
The coefficient vector of length \code{P} (number effects) for computing the
systematic utility \eqn{V = X\beta}.

In the latent class case (\code{lc = TRUE}), \code{beta} is a \code{list} of length \code{C} of
such coefficients, where \code{C} is the number of latent classes.}

\item{Omega}{[\code{matrix(nrow = P_r, ncol = P_r)} | \code{NULL} | \code{list}]\cr
The covariance matrix of random effects of dimension \code{P_r} times \code{P_r},
where \code{P_r} less than \code{P} is the number of random effects.

Can be \code{NULL} for no random effects.

In the latent class case (\code{lc = TRUE}), \code{Omega} is a \code{list} of length \code{C} of
such covariance matrices, where \code{C} is the number of latent classes.}

\item{Sigma}{[\code{matrix(nrow = J, ncol = J)} | \code{numeric(1)}]\cr
The covariance matrix of dimension \code{J} times \code{J} (number alternatives) for
the Gaussian error term \eqn{\epsilon = U - V}.

In the ordered case (\code{ordered = TRUE}), \code{Sigma} is a single, non-negative
\code{numeric}.}

\item{gamma}{[\code{NULL} | \code{numeric(J - 1)}]\cr
Only relevant in the ordered case (\code{ordered = TRUE}). It defines the
non-decreasing boundaries of the utility categories.

The event \eqn{U \leq \gamma_j} means that alternative \eqn{j} is chosen,
while \eqn{U > \gamma_{J - 1}} means that alternative \eqn{J} is chosen.}

\item{weights}{[\code{NULL} | \code{numeric(C)}]\cr
The weights for the latent classes in the latent class case (\code{lc = TRUE}).}

\item{re_position}{[\code{integer(P_r)}]\cr
The index positions of the random effects in the coefficient vector \code{beta}.

By default, the last \eqn{P_r} entries of \code{beta} are considered as random,
where \eqn{P_r} is the dimension of Omega.}

\item{gcdf}{[\verb{function(upper, corr)}]\cr
A function that computes (or approximates) the centered Gaussian CDF
(mean is zero) based on the upper integration limit \code{upper} and correlation
matrix \code{corr}. The output is expected to be a single \code{numeric} value between
zero and one.

In the no-panel (\code{panel = FALSE}) ordered case (\code{ordered = TRUE}),
\code{stats::pnorm()} is used to calculate the one-dimensional Gaussian CDF.}

\item{lower_bound}{[\code{numeric(1)}]\cr
A lower bound for the probabilities for numerical reasons. Probabilities are
returned as \code{max(prob, lower_bound)}.}

\item{input_checks}{[\code{logical(1)}]\cr
Perform input checks. Set to \code{FALSE} to skip them.}

\item{ordered, ranked, mixed, panel, lc}{[\code{logical(1)}]\cr
Flags indicating the model type. These are determined automatically based on
the input arguments.}
}
\value{
A \code{numeric} \code{vector} of length \code{N}, the probabilities for the observed
choices \code{y}.

In the panel case (\code{panel = TRUE}), the probabilities of the observed choice
sequence of length \code{length(Tp)}.

If \code{y} is \code{NULL} and in the non-panel case (\code{panel = FALSE}), a matrix of
dimension \code{N} times \code{J}, the probabilities for all alternatives.
In the ranked case (\code{ranked = TRUE}), only first place choice probabilities
are computed, which is equivalent to computing choice probabilities in the
regular (maximum utility) model.
}
\description{
These helper functions calculate probit choice probabilities for various
scenarios:
\itemize{
\item in the regular (\verb{choiceprob_mnp_*}), ordered (\verb{*_ordered}), and
ranked (\code{ranked = TRUE}) case,
\item in the normally mixed (\verb{choiceprob_mmnp_*}) and latent class (\verb{*_lc}) case,
\item for panel data (\verb{*_panel}),
\item based on the full likelihood (\code{cml = "no"}), the full pairwise composite
marginal likelihood (\code{cml = "fp"}), and the adjacent pairwise composite
marginal likelihood (\code{cml = "ap"}),
\item for the observed choices or for all alternatives (if \code{y} is \code{NULL}).
}

The function \code{choiceprob_probit()} is the general API which calls the
specialized functions and can perform input checks.
}
\keyword{probability}
