% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/2_visualization.r
\name{global_view_legwork}
\alias{global_view_legwork}
\title{The legwork behind the scenes for the global view}
\usage{
global_view_legwork(
  cheem_ls,
  primary_obs = NULL,
  comparison_obs = NULL,
  color = c("default", "residual", "log_maha.data", "cor_attr_proj.y")
)
}
\arguments{
\item{cheem_ls}{A return from \code{cheem_ls()}, a list of data frames.}

\item{primary_obs}{The rownumber of the primary observation. Its local
attribution becomes the 1d projection basis, and the point it highlighted
as a dashed line. Defaults to NULL, no highlighting applied.}

\item{comparison_obs}{The rownumber of the comparison observation. Point
is highlighted as a dotted line. Defaults to NULL, no highlighting applied.}

\item{color}{The name of the column in cheem_ls$global_view_df to map to
color. Expects c("default", "residual", "log_maha.data", "cor_attr_proj.y").
Defaults to "default"; predicted_class for classification, dummy class
for regression.}
}
\value{
a \code{ggplot2} object, waiting to be rendered with \code{global_view} or
\code{global_view_subplots}.
}
\description{
Not meant for end user. This is an internal legwork function to
keep from repeating global_view code.
}
\seealso{
Other cheem consumers: 
\code{\link{global_view}()},
\code{\link{radial_cheem_tour}()},
\code{\link{run_app}()}
}
\concept{cheem consumers}
