% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/angle-functions.R
\name{distanceToPlane}
\alias{distanceToPlane}
\title{Distance to a Reference Plane}
\usage{
distanceToPlane(x, p1 = c(0, 0, 0), p2 = c(0, 1, 0), p3 = c(1, 0, 0), from = 1)
}
\arguments{
\item{x}{a single input track; a matrix whose first column is time and whose
remaining columns are a spatial coordinate.}

\item{p1, p2, p3}{numeric vectors of coordinates of three points specifying a reference plane to
compute distances to.}

\item{from}{index, or vector of indices, of the first row of the track. If
\code{from} is a vector, distances are returned for all steps starting at
the indices in \code{from}.}
}
\value{
A single distance.
}
\description{
Compute the (shortest) distance between the starting point of a track and a reference plane.
Useful to detect directed movement and/or tracking artefacts.
}
\examples{
## Plotting the angle versus the distance to a reference plane can be informative to
## detect tracking artefacts near the border of the imaging volume.
## We should be suspicious especially when small angles are more frequent at low distances
## to the border planes.
load( system.file("extdata", "TCellsRaw.rda", package="celltrackR" ) )
steps <- subtracks( TCellsRaw, 1 )
minz <- boundingBox( TCellsRaw )["min","z"]
## Compute angles and distances to the lower plane in z-dimension
angles <- sapply( steps, angleToPlane, p1 = c(0,0,minz), p2 = c(1,0,minz), p3 = c(0,1,minz) )
distances <- sapply( steps, distanceToPlane, p1 = c(0,0,minz), p2 = c(1,0,minz), p3 = c(0,1,minz) )
scatter.smooth( distances, angles )
abline( h = 32.7, col = "red" )
}
\seealso{
\code{\link{angleToPlane}} to compute the angle to the plane, and
 \code{\link{AngleAnalysis}} for other methods to compute angles and distances.
}
