% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/simulate-tracks.R
\name{bootstrapTrack}
\alias{bootstrapTrack}
\title{Simulate Tracks via Bootstrapping of Speed and Turning Angle from a Real Track Dataset}
\usage{
bootstrapTrack(nsteps, trackdata)
}
\arguments{
\item{nsteps}{desired number of steps (e.g. 10 steps generates a track with 11 positions).}

\item{trackdata}{a tracks object to extract speeds and turning angles from.}
}
\value{
A data frame  containing in cell track with \code{nsteps} steps in
the same number of dimensions as the original data is returned.

## Generate bootstrapped tracks of the TCell data; compare its speed distribution to the
## original data (should be the same).
T.bootstrap <- bootstrapTrack( 100, TCells )
step.speeds.real <- sapply( subtracks(TCells,1), speed )
step.speeds.bootstrap <- sapply( subtracks( T.bootstrap, 1), speed )
qqplot( step.speeds.real, step.speeds.bootstrap )
}
\description{
Returns a simulated dataset by sampling from the speed and turning angle distributions from an
original track dataset (only in 2 or 3 dimensions)
}
\details{
The number of dimensions is kept the same as in the original data (if data is 3D but
simulated tracks should be 2D, consider calling \code{\link{projectDimensions}} on the input
data before supplying it to \code{bootstrapTrack}). The time interval between "measurements"
of the simulated track equals that in the real data and is found via \code{\link{timeStep}}.
The first step starts at the origin in a random direction, with a speed sampled from the
speed distribution to determine its displacement. All subsequent steps also have their
turning angles sampled from the turning angle distribution in the data.
}
