% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/disco-class.R
\name{summary.Disco}
\alias{summary.Disco}
\title{Summarize a Disco Object}
\usage{
\method{summary}{Disco}(object, ...)
}
\arguments{
\item{object}{A \code{Disco} object.}

\item{...}{Additional arguments (not used).}
}
\value{
Invisibly returns the \code{Disco} object.
}
\description{
Summarize a Disco Object
}
\examples{
data(tpc_example)
kn <- knowledge(
  tpc_example,
  tier(
    child ~ starts_with("child"),
    youth ~ starts_with("youth"),
    old ~ starts_with("old")
  )
)
cd_tges <- tpc(engine = "causalDisco", test = "fisher_z")
disco_cd_tges <- disco(data = tpc_example, method = cd_tges, knowledge = kn)
summary(disco_cd_tges)

}
