% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/knowledge-verbs.R
\name{add_tier}
\alias{add_tier}
\title{Add a Tier to Knowledge}
\usage{
add_tier(kn, tier, before = NULL, after = NULL)
}
\arguments{
\item{kn}{A \code{Knowledge} object.}

\item{tier}{Bare symbol / character (label) \strong{or} numeric literal.}

\item{before, after}{Optional anchor relative to an existing tier label,
tier index, or variable.  Once the \code{Knowledge} object already
has >= 1 tier, you must supply \strong{exactly one} of these.}
}
\value{
The updated \code{Knowledge} object.
}
\description{
Adds a new tier to the \code{Knowledge} object, either at the start, end,
or before/after an existing tier.
}
\examples{
data(tpc_example)

# create Knowledge object using verbs
kn1 <- knowledge() |>
  add_vars(names(tpc_example)) |>
  add_tier(child) |>
  add_tier(old, after = child) |>
  add_tier(youth, before = old) |>
  add_to_tier(child ~ starts_with("child")) |>
  add_to_tier(youth ~ starts_with("youth")) |>
  add_to_tier(old ~ starts_with("oldage")) |>
  require_edge(child_x1 ~ youth_x3) |>
  forbid_edge(child_x2 ~ youth_x4) |>
  add_exogenous(child_x1) # synonym: add_exo()

# set kn1 to frozen
# (meaning you cannot add variables to the Knowledge object anymore)
# this is to get a true on the identical check
kn1$frozen <- TRUE

# create identical Knowledge object using DSL
kn2 <- knowledge(
  tpc_example,
  tier(
    child ~ starts_with("child"),
    youth ~ starts_with("youth"),
    old ~ starts_with("oldage")
  ),
  child_x1 \%-->\% youth_x3,
  child_x2 \%!-->\% youth_x4,
  exo(child_x1) # synonym: exogenous()
)

print(identical(kn1, kn2))

# cannot require an edge against tier direction
try(
  kn1 |> require_edge(oldage_x6 ~ child_x1)
)

# cannot forbid and require same edge
try(
  kn1 |> forbid_edge(child_x1 ~ youth_x3)
)
}
\seealso{
Other knowledge functions: 
\code{\link{+.Knowledge}()},
\code{\link{add_exogenous}()},
\code{\link{add_to_tier}()},
\code{\link{add_vars}()},
\code{\link{as_bnlearn_knowledge}()},
\code{\link{as_pcalg_constraints}()},
\code{\link{as_tetrad_knowledge}()},
\code{\link{convert_tiers_to_forbidden}()},
\code{\link{deparse_knowledge}()},
\code{\link{forbid_edge}()},
\code{\link{get_tiers}()},
\code{\link{knowledge}()},
\code{\link{knowledge_to_caugi}()},
\code{\link{remove_edge}()},
\code{\link{remove_tiers}()},
\code{\link{remove_vars}()},
\code{\link{reorder_tiers}()},
\code{\link{reposition_tier}()},
\code{\link{require_edge}()},
\code{\link{seq_tiers}()},
\code{\link{unfreeze}()}
}
\concept{knowledge}
\concept{knowledge functions}
