% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/queries.R
\name{neighbors}
\alias{neighbors}
\alias{neighbours}
\title{Get neighbors of nodes in a \code{caugi}}
\usage{
neighbors(
  cg,
  nodes = NULL,
  index = NULL,
  mode = c("all", "in", "out", "undirected", "bidirected", "partial")
)

neighbours(
  cg,
  nodes = NULL,
  index = NULL,
  mode = c("all", "in", "out", "undirected", "bidirected", "partial")
)
}
\arguments{
\item{cg}{A \code{caugi} object.}

\item{nodes}{A vector of node names, a vector of unquoted
node names, or an expression combining these with \code{+} and \code{c()}.}

\item{index}{A vector of node indexes.}

\item{mode}{Character; specifies which types of neighbors to return:
\describe{
\item{\code{"all"}}{All neighbors (default)}
\item{\code{"in"}}{Parents: nodes with directed edges pointing
INTO the target node (equivalent to \code{parents()})}
\item{\code{"out"}}{Children: nodes with directed edges pointing
OUT from the target node (equivalent to \code{children()})}
\item{\code{"undirected"}}{Nodes connected via undirected (\verb{---}) edges}
\item{\code{"bidirected"}}{Nodes connected via bidirected (\verb{<->}) edges
(equivalent to \code{spouses()} for ADMGs)}
\item{\code{"partial"}}{Nodes connected via partial edges (edges with circle
endpoints: \code{o-o}, \verb{o->}, \code{--o})}
}

Not all modes are valid for all graph classes:
\itemize{
\item DAG: \code{"in"}, \code{"out"}, \code{"all"} only
\item PDAG: \code{"in"}, \code{"out"}, \code{"undirected"}, \code{"all"}
\item UG: \code{"undirected"}, \code{"all"} only
\item ADMG: \code{"in"}, \code{"out"}, \code{"bidirected"}, \code{"all"}
\item UNKNOWN: all modes allowed
}}
}
\value{
Either a character vector of node names (if a single node is
requested) or a list of character vectors (if multiple nodes are requested).
}
\description{
Get neighbors of a node in the graph, optionally filtered by edge direction
or type. This function works for all graph classes including \code{UNKNOWN}.
}
\examples{
cg <- caugi(
  A \%-->\% B,
  B \%-->\% C,
  class = "DAG"
)
neighbors(cg, "A") # "B"
neighbors(cg, index = 2) # "A" "C"
neighbors(cg, "B") # "A" "C"
neighbors(cg, c("B", "C"))
#> $B
#> [1] "A" "C"
#>
#> $C
#> [1] "B"

# Using mode to filter by edge direction
neighbors(cg, "B", mode = "in") # "A" (parents)
neighbors(cg, "B", mode = "out") # "C" (children)

# Works for UNKNOWN graphs too
cg_unknown <- caugi(
  A \%-->\% B,
  B \%---\% C,
  C \%o->\% D,
  class = "UNKNOWN"
)
neighbors(cg_unknown, "B", mode = "in") # "A"
neighbors(cg_unknown, "B", mode = "undirected") # "C"
neighbors(cg_unknown, "C", mode = "partial") # "D"

}
\seealso{
Other queries: 
\code{\link{ancestors}()},
\code{\link{anteriors}()},
\code{\link{children}()},
\code{\link{descendants}()},
\code{\link{districts}()},
\code{\link{edge_types}()},
\code{\link{edges}()},
\code{\link{exogenous}()},
\code{\link{is_acyclic}()},
\code{\link{is_admg}()},
\code{\link{is_ag}()},
\code{\link{is_caugi}()},
\code{\link{is_cpdag}()},
\code{\link{is_dag}()},
\code{\link{is_empty_caugi}()},
\code{\link{is_mag}()},
\code{\link{is_pdag}()},
\code{\link{is_ug}()},
\code{\link{m_separated}()},
\code{\link{markov_blanket}()},
\code{\link{nodes}()},
\code{\link{parents}()},
\code{\link{same_nodes}()},
\code{\link{spouses}()},
\code{\link{subgraph}()},
\code{\link{topological_sort}()}
}
\concept{queries}
