% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/operations.R
\name{latent_project}
\alias{latent_project}
\title{Project latent variables from a DAG to an ADMG}
\usage{
latent_project(cg, latents)
}
\arguments{
\item{cg}{A \code{caugi} object of class \code{"DAG"}.}

\item{latents}{Character vector of latent variable names to project out.}
}
\value{
A \code{caugi} object of class \code{"ADMG"} containing only the observed
variables.
}
\description{
Projects out latent (unobserved) variables from a DAG to produce an
Acyclic Directed Mixed Graph (ADMG) over the observed variables.
}
\examples{
# DAG with latent confounder U
dag <- caugi(
  U \%-->\% X,
  U \%-->\% Y,
  X \%-->\% Y,
  class = "DAG"
)

# Project out the latent variable
admg <- latent_project(dag, latents = "U")
# Result: X -> Y, X <-> Y (children of U become bidirected-connected)
edges(admg)

# DAG with directed path through latent
dag2 <- caugi(
  X \%-->\% L,
  L \%-->\% Y,
  class = "DAG"
)

# Project out the latent variable
admg2 <- latent_project(dag2, latents = "L")
# Result: X -> Y (directed path X -> L -> Y becomes X -> Y)
edges(admg2)

}
\seealso{
Other operations: 
\code{\link{condition_marginalize}()},
\code{\link{exogenize}()},
\code{\link{moralize}()},
\code{\link{mutate_caugi}()},
\code{\link{skeleton}()}
}
\concept{operations}
