% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/queries.R
\name{parents}
\alias{parents}
\title{Get parents of nodes in a \code{caugi}}
\usage{
parents(cg, nodes = NULL, index = NULL)
}
\arguments{
\item{cg}{A \code{caugi} object.}

\item{nodes}{A vector of node names, a vector of unquoted
node names, or an expression combining these with \code{+} and \code{c()}.}

\item{index}{A vector of node indexes.}
}
\value{
Either a character vector of node names (if a single node is
requested) or a list of character vectors (if multiple nodes are requested).
}
\description{
Get parents of node in a graph. Note that not both nodes and index can be
given.
}
\examples{
cg <- caugi(
  A \%-->\% B,
  B \%-->\% C,
  class = "DAG"
)
parents(cg, "A") # NULL
parents(cg, index = 2) # "A"
parents(cg, "B") # "A"
parents(cg, c("B", "C"))
#> $B
#> [1] "A"
#>
#> $C
#> [1] "B"

}
\seealso{
Other queries: 
\code{\link{ancestors}()},
\code{\link{children}()},
\code{\link{descendants}()},
\code{\link{edge_types}()},
\code{\link{edges}()},
\code{\link{exogenous}()},
\code{\link{is_acyclic}()},
\code{\link{is_caugi}()},
\code{\link{is_cpdag}()},
\code{\link{is_dag}()},
\code{\link{is_empty_caugi}()},
\code{\link{is_pdag}()},
\code{\link{is_ug}()},
\code{\link{markov_blanket}()},
\code{\link{neighbors}()},
\code{\link{nodes}()},
\code{\link{same_nodes}()},
\code{\link{subgraph}()}
}
\concept{queries}
