% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/queries.R
\name{is_dag}
\alias{is_dag}
\title{Is the \code{caugi} graph a DAG?}
\usage{
is_dag(cg, force_check = FALSE)
}
\arguments{
\item{cg}{A \code{caugi} object.}

\item{force_check}{Logical; if \code{TRUE}, the function will test if the graph is
a DAG, if \code{FALSE} (default), it will look at the graph class and match
it, if possible.}
}
\value{
A logical value indicating whether the graph is a DAG.
}
\description{
Checks if the given \code{caugi} graph is a
Directed Acyclic Graph (DAG).
}
\examples{
cg_dag_class <- caugi(
  A \%-->\% B,
  class = "DAG"
)
is_dag(cg_dag_class) # TRUE
cg_dag_but_pdag_class <- caugi(
  A \%-->\% B,
  class = "PDAG"
)
is_dag(cg_dag_but_pdag_class) # TRUE
cg_cyclic <- caugi(
  A \%-->\% B,
  B \%-->\% C,
  C \%-->\% A,
  class = "UNKNOWN",
  simple = FALSE
)
is_dag(cg_cyclic) # FALSE

cg_undirected <- caugi(
  A \%---\% B,
  class = "UNKNOWN"
)
is_dag(cg_undirected) # FALSE

}
\seealso{
Other queries: 
\code{\link{ancestors}()},
\code{\link{children}()},
\code{\link{descendants}()},
\code{\link{edge_types}()},
\code{\link{edges}()},
\code{\link{exogenous}()},
\code{\link{is_acyclic}()},
\code{\link{is_caugi}()},
\code{\link{is_cpdag}()},
\code{\link{is_empty_caugi}()},
\code{\link{is_pdag}()},
\code{\link{is_ug}()},
\code{\link{markov_blanket}()},
\code{\link{neighbors}()},
\code{\link{nodes}()},
\code{\link{parents}()},
\code{\link{same_nodes}()},
\code{\link{subgraph}()}
}
\concept{queries}
