% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/adjustment.R
\name{all_backdoor_sets}
\alias{all_backdoor_sets}
\title{Get all backdoor sets up to a certain size.}
\usage{
all_backdoor_sets(
  cg,
  X = NULL,
  Y = NULL,
  X_index = NULL,
  Y_index = NULL,
  minimal = TRUE,
  max_size = 3L
)
}
\arguments{
\item{cg}{A \code{caugi}.}

\item{X, Y}{Single node name.}

\item{X_index, Y_index}{Optional 1-based indices (exclusive with name args).}

\item{minimal}{Logical; if \code{TRUE} (default), only minimal sets are returned.}

\item{max_size}{Integer; maximum size of sets to consider (default 3).}
}
\value{
A list of character vectors, each an adjustment set
(possibly empty).
}
\description{
This function returns the backdoor sets up to size \code{max_size},
which per default is set to 10.
}
\examples{
cg <- caugi(
  C \%-->\% X,
  X \%-->\% F,
  X \%-->\% D,
  A \%-->\% X,
  A \%-->\% K,
  K \%-->\% Y,
  D \%-->\% Y,
  D \%-->\% G,
  Y \%-->\% H,
  class = "DAG"
)

all_backdoor_sets(cg, X = "X", Y = "Y", max_size = 3L, minimal = FALSE)
#> [[1]]
#> [1] "A"
#>
#> [[2]]
#> [1] "K"
#>
#> [[3]]
#> [1] "C" "A"
#>
#> [[4]]
#> [1] "C" "K"
#>
#> [[5]]
#> [1] "A" "K"
#>
#> [[6]]
#> [1] "C" "A" "K"

all_backdoor_sets(cg, X = "X", Y = "Y", max_size = 3L, minimal = TRUE)
#> [[1]]
#> [1] "A"
#>
#> [[2]]
#> [1] "K"

}
\seealso{
Other adjustment: 
\code{\link{adjustment_set}()},
\code{\link{d_separated}()},
\code{\link{is_valid_backdoor}()}
}
\concept{adjustment}
