% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/adapt_dwd.R
\name{dwd_warnings_nowcast}
\alias{dwd_warnings_nowcast}
\title{Fetch DWD nowcast warnings}
\usage{
dwd_warnings_nowcast(
  language = c("de", "en"),
  safe = TRUE,
  refresh = FALSE,
  flatten = FALSE,
  flatten_mode = "json"
)
}
\arguments{
\item{language}{Language code ("de" or "en").}

\item{safe}{Logical; apply throttling and caching.}

\item{refresh}{Logical; refresh cached responses.}

\item{flatten}{Logical; drop nested list columns.}

\item{flatten_mode}{Flatten strategy for list columns. Use "unnest" to
expand list-columns into multiple rows.}
}
\value{
A tibble with nowcast warnings.

Includes \code{start_time} and \code{end_time} as POSIXct in Europe/Berlin.
}
\description{
Fetch DWD nowcast warnings
}
\details{
Retrieves nowcast weather warnings from the DWD App API.
Official docs: https://dwd.api.bund.dev.
}
\examples{
\dontrun{
dwd_warnings_nowcast(language = "de", flatten = TRUE)
}

}
\seealso{
\code{\link[=dwd_municipality_warnings]{dwd_municipality_warnings()}} and \code{\link[=dwd_coast_warnings]{dwd_coast_warnings()}}.
}
