% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/adapt_autobahn.R
\name{autobahn_closure_details}
\alias{autobahn_closure_details}
\title{Get Autobahn closure details}
\usage{
autobahn_closure_details(closure_id, flatten = FALSE, flatten_mode = "json")
}
\arguments{
\item{closure_id}{Closure identifier.}

\item{flatten}{Logical; drop nested list columns.}

\item{flatten_mode}{Flatten strategy for list columns. Use "unnest" to
expand list-columns into multiple rows.}
}
\value{
A tibble with closure details.
}
\description{
Get Autobahn closure details
}
\details{
Returns full details for a single closure entry.
Official docs: https://autobahn.api.bund.dev.
}
\examples{
\dontrun{
roads <- autobahn_roads()
closures <- autobahn_closures(roads$road_id[[1]])
autobahn_closure_details(closures$identifier[[1]])
}
}
\seealso{
\code{\link[=autobahn_closures]{autobahn_closures()}} to list closures.
}
