% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/elas_equalizer.R
\name{elas_equalizer}
\alias{elas_equalizer}
\title{Using elasticity to calculating distance between utility at tangency and at
notch point}
\usage{
elas_equalizer(elas, t1, t2, Tax, zstar, delta_zed, binw)
}
\arguments{
\item{elas}{elasticity of earnings w.r.t.  net-of-tax rate}

\item{t1}{Tax rate before notch/kink}

\item{t2}{Tax rate after notch/kink}

\item{Tax}{Height of notch (zero for pure kink)}

\item{zstar}{Place of notch/kink (critical earning point)}

\item{delta_zed}{The notch size in bin units}

\item{binw}{Bin width}
}
\value{
Absolute value of utility at \eqn{zstar+delta_zed} minus utility at
kink/notch point.
}
\description{
Given an elasticity, a budget set, and the earnings of the marginal buncher,
calculate the utility at notch point and at marginal buncher's earning, and
return the absolute difference. Equating these two utilities helps find the
elasticity of the marginal buncher. See equations (3) and (4) at Kelven and
Waseem (2013)
}
\examples{
elas_equalizer(0.2, 0.1, 0.2, 100, 1000, 20, 10)
# The elasticity value to minimize this is ~0.0716:
elas_equalizer(0.0716, 0.1, 0.2, 100, 1000, 20, 10)

}
\references{
Kleven, H. and Waseem, Mazhar (2013) \emph{Using notches to
uncover optimization frictions and structural elasticities: Theory and
evidence from Pakistan}, The Quarterly Journal of Economics 128(2)
}
