% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bc_b.R
\name{bc.b}
\alias{bc.b}
\alias{bc.b,ANY-method}
\title{Broadcasted Boolean Operations}
\usage{
bc.b(x, y, op, ...)

\S4method{bc.b}{ANY}(x, y, op)
}
\arguments{
\item{x, y}{conformable vectors/arrays of type \code{logical}, \code{numeric}, or \code{raw}. \cr
Note that input with type of \code{double} will be coerced to \code{integer}.}

\item{op}{a single string, giving the operator. \cr
Supported Boolean operators: &, |, xor, nand, ==, !=, <, >, <=, >=.}

\item{...}{further arguments passed to or from methods. \cr \cr}
}
\value{
Normally: \cr
A logical array/vector as a result of the broadcasted Boolean operation. \cr
\cr
If both \code{x} and \code{y} are type of raw: \cr
A raw array/vector as a result of the broadcasted Boolean operation,
where \code{01} codes for \code{TRUE} and \code{00} codes for \code{FALSE}. \cr
This is convenient as \code{raw} requires less memory space than \code{logical}. \cr \cr
}
\description{
The \code{bc.b()} function
performs broadcasted logical (or Boolean) operations on 2 arrays. \cr
\cr
Please note that these operations will treat the input as \code{logical}. \cr
Therefore, something like \code{bc.b(1, 2, "==")} returns \code{TRUE},
because both \code{1} and \code{2} are \code{TRUE} when treated as \code{logical}. \cr
\cr
For regular relational operators, see \link{bc.rel}. \cr \cr
}
\details{
\code{bc.b()} efficiently casts the input to logical. \cr
Since the input is treated as logical, the following equalities hold for \code{bc.b()}:
\itemize{
\item "==" is equivalent to \code{(x & y) | (!x & !y)}, but faster;
\item "!=" is equivalent to \code{xor(x, y)};
\item "<" is equivalent to \code{(!x & y)}, but faster;
\item ">" is equivalent to \code{(x & !y)}, but faster;
\item "<=" is equivalent to \code{(!x & y) | (y == x)}, but faster;
\item ">=" is equivalent to \code{(x & !y) | (y == x)}, but faster. \cr \cr
}
}
\examples{
x.dim <- c(4:2)
x.len <- prod(x.dim)
x.data <- sample(c(TRUE, FALSE, NA), x.len, TRUE)
x <- array(x.data, x.dim)
y <- array(1:50, c(4,1,1))

bc.b(x, y, "&")
bc.b(x, y, "|")
bc.b(x, y, "xor")
bc.b(x, y, "nand")
bc.b(x, y, "==")
bc.b(x, y, "!=")

}
\seealso{
\link{broadcast_operators} \cr
}
