% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/theme.R
\name{theme_brand_thematic}
\alias{theme_brand_thematic}
\alias{theme_brand_thematic_on}
\title{Create a thematic theme using brand colors}
\usage{
theme_brand_thematic(
  brand = NULL,
  background = NULL,
  foreground = NULL,
  accent = NULL,
  ...
)

theme_brand_thematic_on(
  brand = NULL,
  background = NULL,
  foreground = NULL,
  accent = NULL,
  ...
)
}
\arguments{
\item{brand}{One of:
\itemize{
\item \code{NULL} (default): Automatically detect and read a _brand.yml file
\item A path to a brand.yml file or directory containing _brand.yml
\item A brand object (as returned by \code{read_brand_yml()} or \code{as_brand_yml()})
\item \code{FALSE}: Don't use a brand file; explicit colors must be provided
}}

\item{background}{The background color, defaults to \code{brand.color.background}.
If provided directly, this value can be a valid R color or the name of a
color in \code{brand.color} or \code{brand.color.palette}.}

\item{foreground}{The foreground color, defaults to \code{brand.color.foreground}.
If provided directly, this value can be a valid R color or the name of a
color in \code{brand.color} or \code{brand.color.palette}.}

\item{accent}{The accent color, defaults to \code{brand.color.primary} or
\code{brand.color.palette.accent}. If provided directly, this value can be a
valid R color or the name of a color in \code{brand.color} or
\code{brand.color.palette}.}

\item{...}{Additional arguments passed to \code{\link[thematic:thematic_on]{thematic::thematic_theme()}} or
\code{\link[thematic:thematic_on]{thematic::thematic_on()}}.}
}
\value{
\code{\link[thematic:thematic_theme]{thematic_theme()}} returns a theme object as a list (which can be
activated with \code{\link[thematic:thematic_with_theme]{thematic_with_theme()}} or \code{\link[thematic:thematic_set_theme]{thematic_set_theme()}}).

\code{\link[thematic:thematic_on]{thematic_on()}}, \code{\link[thematic:thematic_off]{thematic_off()}}, and \code{\link[thematic:thematic_shiny]{thematic_shiny()}} all return
the previous global theme.
}
\description{
Apply thematic styling using explicit colors or by automatically extracting
colors from a \strong{brand.yml} file. This function sets global theming for base
R graphics.
}
\section{Functions}{
\itemize{
\item \code{theme_brand_thematic()}: brand.yml wrapper for
\code{\link[thematic:thematic_on]{thematic::thematic_theme()}}

\item \code{theme_brand_thematic_on()}: brand.yml wrapper for
\code{\link[thematic:thematic_on]{thematic::thematic_theme()}}

}}
\examples{
\dontshow{if (rlang::is_installed("thematic") && rlang::is_installed("ggplot2")) withAutoprint(\{ # examplesIf}
brand <- as_brand_yml('
color:
  palette:
    black: "#1A1A1A"
    white: "#F9F9F9"
    orange: "#FF6F20"
  foreground: black
  background: white
  primary: orange')


library(ggplot2)

thematic::thematic_with_theme(theme_brand_thematic(brand), {
  ggplot(diamonds, aes(carat, price)) +
    geom_point()
})
\dontshow{\}) # examplesIf}
}
\seealso{
See the "Branded Theming" section of \code{\link[=theme_brand_ggplot2]{theme_brand_ggplot2()}} for
more details on how the \code{brand} argument works.

Other branded theming functions: 
\code{\link{theme_brand_flextable}()},
\code{\link{theme_brand_ggplot2}()},
\code{\link{theme_brand_gt}()},
\code{\link{theme_brand_plotly}()}
}
\concept{branded theming functions}
