% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/graph.R
\name{new_graph}
\alias{new_graph}
\alias{is_graph}
\alias{graph_nodes}
\alias{graph_edges}
\alias{graph_combos}
\alias{as_graph}
\alias{as_graph.graph}
\alias{as_graph.list}
\title{Graph object}
\usage{
new_graph(nodes = list(), edges = list(), combos = list())

is_graph(x)

graph_nodes(x)

graph_edges(x)

graph_combos(x)

as_graph(x, ...)

\method{as_graph}{graph}(x, ...)

\method{as_graph}{list}(x, ...)
}
\arguments{
\item{nodes}{Graph nodes (i.e. board blocks).}

\item{edges}{Graph edges (i.e. board links).}

\item{combos}{Node groups (i.e. board stacks).}

\item{x}{Object to test or convert.}

\item{...}{Generic consistency.}
}
\value{
\describe{
\item{\code{new_graph()}}{A graph object
of class "graph" containing nodes, edges, and combos lists.}
\item{\code{is_graph()}}{\code{TRUE} if \code{x} is a
graph object, \code{FALSE} otherwise.}
\item{\code{graph_nodes()}}{A list of graph nodes.}
\item{\code{graph_edges()}}{A list of graph edges.}
\item{\code{graph_combos()}}{A list of graph
combos (node groups).}
\item{\code{as_graph()}}{A graph object converted
from the input.}
}
}
\description{
R list-based representation of a g6 graph object.
}
\details{
\describe{
\item{\code{new_graph()}}{Creates a new graph
object with the specified nodes, edges, and combos.}
\item{\code{is_graph()}}{Tests whether an object
is a valid graph object.}
\item{\code{graph_nodes()}}{Extracts the nodes
component from a graph object.}
\item{\code{graph_edges()}}{Extracts the edges
component from a graph object.}
\item{\code{graph_combos()}}{Extracts the combos
component from a graph object.}
\item{\code{as_graph()}}{Generic function to
convert objects to graph format.}
}
}
