% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gcomputation.R
\name{predict_multistep}
\alias{predict_multistep}
\title{Multi-step Predictive Simulation for the Bivariate Hurdle Model}
\usage{
predict_multistep(fit_obj, DT, k, Tcut, h, ndraws = 800, seed = NULL)
}
\arguments{
\item{fit_obj}{A list returned by \code{fit_one()}, containing at least
\code{$fit} (a CmdStanR fit object), \code{$spec} (model specification),
and \code{$controls} (character vector of control variables).}

\item{DT}{A \code{data.frame} or \code{data.table} with the covariates and
original time series, including columns \code{I}, \code{C},
\code{Regime}, \code{trans_PS}, \code{trans_SF}, \code{trans_FC} and
\code{log_exposure50}.}

\item{k}{Integer; lag order used in the fitted model.}

\item{Tcut}{Integer; last time index used as the starting point for
prediction (historical window is \code{1:Tcut}).}

\item{h}{Integer; forecast horizon (number of steps ahead to simulate).}

\item{ndraws}{Integer; maximum number of posterior draws to use for
simulation (default 800). If larger than available draws, it is truncated.}

\item{seed}{Optional integer; random seed passed to \code{set.seed()} for
reproducibility of the simulation.}
}
\value{
A list with two components:
\item{pred_I}{Numeric matrix of dimension \code{S x h} with simulated paths
for \code{I}, where \code{S} is the number of posterior draws used.}
\item{pred_C}{Numeric matrix of dimension \code{S x h} with simulated paths
for \code{C}.}
}
\description{
Generates forward simulations for \code{h} future periods from a fitted
bivariate hurdle negative binomial model (I/C), using posterior draws and
dynamically updating the lagged history as new simulated values are added.
}
\details{
For each selected posterior draw, the function iteratively simulates
\code{h} future values of \code{I} and \code{C}. At each step:
\itemize{
\item The covariate vector is built from lagged outcomes
(up to order \code{k}) and the corresponding row \code{t} of
\code{DT} (trend terms, regime dummies, transition variables and
controls).
\item The hurdle probabilities and negative-binomial means are computed
from the draw-specific parameters.
\item New counts are sampled and appended to the local history so that
subsequent steps use the updated lags.
}
Simulation stops early for a given path if \code{Tcut + step > nrow(DT)}.
}
\examples{
\donttest{
if (interactive() && requireNamespace("cmdstanr", quietly = TRUE)) {
  n <- 120
  DT <- data.table::data.table(
    I = rpois(n, 5), C = rpois(n, 3),
    Regime = factor(sample(c("A","B","C"), n, TRUE)),
    trans_PS = c(rep(1,5), rep(0,n-5)),
    trans_SF = c(rep(0,60), rep(1,5), rep(0,n-65)),
    trans_FC = rep(0, n),
    log_exposure50 = log(runif(n, 40, 60))
  )
  fit_obj <- fit_one(DT, k = 1, spec = "C")
  pred <- predict_multistep(fit_obj, DT, k = 1, Tcut = 100, h = 12,
                            ndraws = 500, seed = 123)
  str(pred$pred_I)
}
}
}
\keyword{internal}
