% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/hurdle-fit.R
\name{.build_model_with_floor}
\alias{.build_model_with_floor}
\title{Build CmdStan model with custom FLOOR constant}
\usage{
.build_model_with_floor(stan_code, floor_value)
}
\arguments{
\item{stan_code}{Character string containing the Stan program. It
must include a line of the form \code{real FLOOR = ...;} that will
be replaced.}

\item{floor_value}{Numeric scalar used to set the constant
\code{FLOOR} in the generated Stan code.}
}
\value{
A CmdStanModel object (requires 'cmdstanr' package).
}
\description{
Takes a Stan program as a single string and replaces the declaration
of the scalar constant \code{FLOOR} with a user supplied numeric
value, then compiles it as a CmdStanR model with threading enabled.
}
\details{
The replacement is performed using a regular expression,
so the Stan code must follow the pattern used in the bivariate
hurdle model templates of this package. The compiled model has
\code{stan_threads} turned on via \code{cpp_options}.
}
\keyword{internal}
