% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sniff_groups_cumulative_citations.R
\name{sniff_groups_cumulative_citations}
\alias{sniff_groups_cumulative_citations}
\title{Calculate Cumulative Citations by Group and Year}
\usage{
sniff_groups_cumulative_citations(groups, min_citations = 5)
}
\arguments{
\item{groups}{A list containing network data with the following components:
\itemize{
\item{network: A tidygraph network object}
\item{pubs_by_year: Publication counts by year}
\item{aggregate: Aggregate network statistics}
}}

\item{min_citations}{Minimum number of citations for a paper to be included in analysis (default: 10).}
}
\value{
A named list (by research group) where each element contains a tibble with:
\itemize{
\item \code{group}: Research group identifier
\item \code{SR}: Paper identifier
\item \code{TC}: Total citations
\item \code{PY}: Publication year
\item \code{Ki}: Total network citations
\item \code{citations_by_year}: A tibble with annual citation counts
(PY: year, citations: count)
\item \code{growth_power}: Growth power score (0-100)
\item \code{growth_consistency}: Percentage of years with citations
\item \code{peak_momentum}: Highest 3-year rolling average citation count
\item \code{early_impact}: Citations in first 5 years
\item \code{recent_momentum}: Citations in last 3 years
\item \code{acceleration_factor}: Ratio of late to early citations
}
}
\description{
This function calculates cumulative citations for papers within research groups,
tracking how citations accumulate over time for highly cited papers.
}
\details{
For each research group, the function:
\itemize{
\item Identifies papers with citations above the threshold
\item Tracks citations to these papers year by year
\item Calculates cumulative citation patterns
\item Computes various growth metrics for citation analysis
}

Works with both Web of Science (WOS) and OpenAlex data formats.
}
\examples{
\dontrun{
# Assuming groups is output from sniff_groups()
# Calculate cumulative citations
groups_cumulative_citations <- sniff_groups_cumulative_citations(groups, min_citations = 5)
# View results for first group
head(groups_cumulative_citations[[1]])
}

}
