% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/twofold_dilution.R
\name{get_TTDs}
\alias{get_TTDs}
\title{Estimation of the Time to Detection of OD measurements}
\usage{
get_TTDs(OD_data, target_OD, codified = FALSE)
}
\arguments{
\item{OD_data}{a tibble (or data.frame) with the readings of the equipment. It
must have a column named \code{time} with the time of the rading and as many additional
columns as conditions}

\item{target_OD}{target OD for the calculation of the TTD}

\item{codified}{whether the columns are codified. If \code{FALSE} (default), the TTD estimated
for each condition is returned as such. If \code{TRUE}, it is assumed that each column
is codified as \code{condition_number-of-dilutions}. Therefore, the results are separated
to simplify the application of \code{\link[=fit_serial_dilution]{fit_serial_dilution()}}}
}
\value{
A tibble with two or three columns. If \code{codified = FALSE}, the tibble has two columns:
\code{condition} (the name of the well according to \code{OD_data}) and \code{TTD} (the estimated time to detection).
If the \code{target_OD} was not reached for some well, it assigns \code{NA}. If \code{codified = TRUE},
the code returns an additional column with the number of dilutions
}
\description{
The function uses linear interpolation to identify the time at which different
wells reached a target optical density
}
\examples{
data("example_od")  # example dataset included int he package

get_TTDs(example_od, target_OD = 0.2)  # default behaviour, returns two columns
get_TTDs(example_od, target_OD = 0.2, codified = TRUE)  # extracts also the number of dilutions


}
