% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/calcs_fitting.R
\name{fit_glm_method}
\alias{fit_glm_method}
\title{Perform GLM (Generalised Linear Model) fitting}
\usage{
fit_glm_method(
  count_data,
  model_formula,
  model_family = c("automatic", "poisson", "quasipoisson", "nb2"),
  fit_link = "identity",
  aberr_module = c("dicentrics", "translocations", "micronuclei")
)
}
\arguments{
\item{count_data}{Count data in data frame form.}

\item{model_formula}{Model formula.}

\item{model_family}{Model family.}

\item{fit_link}{Family link.}

\item{aberr_module}{Aberration module.}
}
\value{
List object containing GLM fit results.
}
\description{
Method based on the paper by Edwards, A. A. et al. (1979). Radiation induced
chromosome aberrations and the Poisson distribution. Radiation and
Environmental Biophysics, 16(2), 89-100. <doi:10.1007/BF01323216>.
}
