% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/telemetry_notices.R
\name{bid_address}
\alias{bid_address}
\title{Create Notice stage from single telemetry issue (sugar)}
\usage{
bid_address(issue, previous_stage, ...)
}
\arguments{
\item{issue}{A single row from bid_telemetry() output}

\item{previous_stage}{Previous BID stage (typically from bid_interpret)}

\item{...}{Additional arguments passed to bid_notice_issue()}
}
\value{
A bid_stage object in the Notice stage
}
\description{
Convenience function that combines issue selection and Notice creation in one step.
Useful for quick workflows where you want to address a specific issue immediately.
}
\examples{
\dontrun{
issues <- bid_telemetry("data.sqlite")
interpret <- bid_interpret("How can we improve user experience?")

# Address the highest impact issue
top_issue <- issues[which.max(issues$impact_rate), ]
notice <- bid_address(top_issue, interpret)
}
}
