% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/indicators.R
\name{margalef}
\alias{margalef}
\title{Margalef Index of Diversity}
\usage{
margalef(taxon, count)
}
\arguments{
\item{taxon}{taxa names (\code{character})}

\item{count}{counts (\code{numeric})}
}
\value{
Margalef diversity index (\code{numeric} \code{vector} of length 1)
}
\description{
Margalef Index of Diversity is given by
\deqn{D = \frac{S-1}{\ln(N)}}{D = (S-1)/ln(N)}
}
\details{
For \eqn{N=1}, the index is set to 0.
}
\examples{
margalef(
    taxon = c("Euspira pulchella", "Nephtys cirrosa"),
    count = c(4, 6)
)

}
