% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Response.R
\docType{class}
\name{Response}
\alias{Response}
\title{Response Class}
\format{
An [`R6::R6Class`] generator for `Response` objects.
}
\description{
A `Response` object represents the HTTP response that a `Beakr` app sends
when handling a request. By convention, the response object is named
`res` (with the corresponding request named `req`).
}
\seealso{
[Router], [Request], [Error]
}
\section{Public fields}{
\if{html}{\out{<div class="r6-fields">}}
\describe{
\item{\code{headers}}{A named list of HTTP response headers.
Defaults to `list("Content-Type" = "text/html")`.}

\item{\code{status}}{An integer HTTP status code. Defaults to `200L`.}

\item{\code{body}}{The response body. May be `NULL`, character, raw, JSON, or base64.}
}
\if{html}{\out{</div>}}
}
\section{Methods}{
\subsection{Public methods}{
\itemize{
\item \href{#method-Response-setHeader}{\code{Response$setHeader()}}
\item \href{#method-Response-setContentType}{\code{Response$setContentType()}}
\item \href{#method-Response-setStatus}{\code{Response$setStatus()}}
\item \href{#method-Response-setBody}{\code{Response$setBody()}}
\item \href{#method-Response-redirect}{\code{Response$redirect()}}
\item \href{#method-Response-json}{\code{Response$json()}}
\item \href{#method-Response-text}{\code{Response$text()}}
\item \href{#method-Response-structured}{\code{Response$structured()}}
\item \href{#method-Response-plot}{\code{Response$plot()}}
\item \href{#method-Response-clone}{\code{Response$clone()}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Response-setHeader"></a>}}
\if{latex}{\out{\hypertarget{method-Response-setHeader}{}}}
\subsection{Method \code{setHeader()}}{
Set a header key-value pair (e.g., `"Content-Type" = "text/html"`).
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Response$setHeader(key, value)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{key}}{Header name.}

\item{\code{value}}{Header value.}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Response-setContentType"></a>}}
\if{latex}{\out{\hypertarget{method-Response-setContentType}{}}}
\subsection{Method \code{setContentType()}}{
Set the response `Content-Type`.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Response$setContentType(type)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{type}}{MIME type string.}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Response-setStatus"></a>}}
\if{latex}{\out{\hypertarget{method-Response-setStatus}{}}}
\subsection{Method \code{setStatus()}}{
Set the HTTP status code.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Response$setStatus(status)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{status}}{Integer HTTP status code.}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Response-setBody"></a>}}
\if{latex}{\out{\hypertarget{method-Response-setBody}{}}}
\subsection{Method \code{setBody()}}{
Set the response body, respecting the current `Content-Type`.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Response$setBody(body)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{body}}{Body content, type depends on `Content-Type`.}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Response-redirect"></a>}}
\if{latex}{\out{\hypertarget{method-Response-redirect}{}}}
\subsection{Method \code{redirect()}}{
Redirect the client by setting status 302 and `Location` header.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Response$redirect(url)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{url}}{The URL to redirect to.}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Response-json"></a>}}
\if{latex}{\out{\hypertarget{method-Response-json}{}}}
\subsection{Method \code{json()}}{
Convert `txt` to JSON and set content type to `"application/json"`.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Response$json(txt, auto_unbox = TRUE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{txt}}{Content to convert to JSON.}

\item{\code{auto_unbox}}{Logical; whether to simplify length-1 vectors.}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Response-text"></a>}}
\if{latex}{\out{\hypertarget{method-Response-text}{}}}
\subsection{Method \code{text()}}{
Set the response body as plain text and content type `"text/html"`.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Response$text(txt)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{txt}}{Content to include as plain text.}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Response-structured"></a>}}
\if{latex}{\out{\hypertarget{method-Response-structured}{}}}
\subsection{Method \code{structured()}}{
Return a structured response depending on `protocol`.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Response$structured(protocol)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{protocol}}{`"http"` or `"websocket"`.}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Response-plot"></a>}}
\if{latex}{\out{\hypertarget{method-Response-plot}{}}}
\subsection{Method \code{plot()}}{
Render a plot to PNG (optionally base64-encode) and set as response body.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Response$plot(plot_object, base64 = TRUE, ...)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{plot_object}}{A plot object to render.}

\item{\code{base64}}{Logical; if `TRUE`, encode image as base64.}

\item{\code{...}}{Passed to [graphics::png()].}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Response-clone"></a>}}
\if{latex}{\out{\hypertarget{method-Response-clone}{}}}
\subsection{Method \code{clone()}}{
The objects of this class are cloneable with this method.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Response$clone(deep = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{deep}}{Whether to make a deep clone.}
}
\if{html}{\out{</div>}}
}
}
}
