% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data_preparation.R
\name{join_lagged_col}
\alias{join_lagged_col}
\title{Dataframe with no lagged column}
\usage{
join_lagged_col(
  df,
  col,
  col_lagged,
  timestamp_col,
  entity_col,
  timestep = NULL
)
}
\arguments{
\item{df}{Dataframe with data with a column with lagged values}

\item{col}{Column with quantity not lagged}

\item{col_lagged}{Column with the same quantity as \code{col}, but the values
are lagged in time}

\item{timestamp_col}{Column with timestamps (e.g. years)}

\item{entity_col}{Column with entities (e.g. countries)}

\item{timestep}{Difference between timestamps (e.g. 10)}
}
\value{
A dataframe with two columns merged, i.e. just one column with the desired
quantity is left.
}
\description{
This function allows to turn data in the format with lagged values for a
chosen column (i.e. there are two columns with the same quantity, but one
column is lagged in time) into the format with just one column
}
\examples{
df <- data.frame(
  year = c(2000, 2001, 2002, 2003, 2004),
  country = c("A", "A", "B", "B", "C"),
  gdp = c(1, 2, 3, 4, 5),
  gdp_lagged = c(NA, 1, 2, 3, 4)
)

join_lagged_col(df, gdp, gdp_lagged, year, country, 1)

}
