% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bbknn.R
\name{RunBBKNN}
\alias{RunBBKNN}
\alias{RunBBKNN.matrix}
\alias{RunBBKNN.Seurat}
\title{Perform batch balanced KNN}
\usage{
RunBBKNN(object, ...)

\method{RunBBKNN}{matrix}(
  object,
  batch_list,
  neighbors_within_batch = 3,
  n_pcs = 50,
  method = c("annoy", "nndescent"),
  metric = "euclidean",
  n_trees = 10L,
  k_build_nndescent = 30,
  trim = NULL,
  set_op_mix_ratio = 1,
  local_connectivity = 1,
  seed = 42,
  verbose = TRUE,
  ...
)

\method{RunBBKNN}{Seurat}(
  object,
  batch_key,
  assay = NULL,
  reduction = "pca",
  n_pcs = 50L,
  graph_name = "bbknn",
  set_op_mix_ratio = 1,
  local_connectivity = 1,
  run_TSNE = TRUE,
  TSNE_name = "tsne",
  TSNE_key = "tSNE_",
  run_UMAP = TRUE,
  UMAP_name = "umap",
  UMAP_key = "UMAP_",
  return.umap.model = FALSE,
  min_dist = 0.3,
  spread = 1,
  seed = 42,
  verbose = TRUE,
  ...
)
}
\arguments{
\item{object}{An object}

\item{...}{Arguments passed to other methods}

\item{batch_list}{A character vector with the same length as nrow(pca)}

\item{neighbors_within_batch}{How many top neighbours to report for each 
batch; total number of neighbours in the initial k-nearest-neighbours 
computation will be this number times the number of batches. This then serves 
as the basis for the construction of a symmetrical matrix of connectivities.}

\item{n_pcs}{Number of dimensions to use. Default is 50.}

\item{method}{Method to find k nearest neighbors (kNNs). One of "annoy" and 
"nndescent".}

\item{metric}{Metric to calculate the distances. The options depend on the 
choice of kNN \code{method}. The following metrics are supported in both 
\code{annoy} and \code{nndescent}:
\itemize{
\item 'euclidean' (the default)
\item 'manhattan'
\item 'hamming'
}
The following metrics are only supported in \code{nndescent}:
\itemize{
\item 'sqeuclidean'
\item 'chebyshev'
\item 'canberra'
\item 'braycurtis' 
\item 'cosine' 
\item 'correlation'
\item 'jaccard' 
\item 'dice'
\item 'matching'
\item 'russellrao' 
\item 'kulsinski' 
\item 'rogerstanimoto' 
\item 'sokalmichener'
\item 'sokalsneath'
\item 'tsss'
\item 'yule'
\item 'hellinger'
}}

\item{n_trees}{The number of trees to use in the random projection forest. 
More trees give higher precision when querying, at the cost of increased run 
time and resource intensity.}

\item{k_build_nndescent}{Used with nndescent neighbour identification. The 
number of neighbours to include when building the approximate nearest 
neighbors index and neighbor graph. More neighbours give higher precision 
when querying, at the cost of increased run time and resource intensity.}

\item{trim}{Trim the neighbours of each cell to these many top 
connectivities. May help with population independence and improve the 
tidiness of clustering. The lower the value the more independent the 
individual populations, at the cost of more conserved batch effect. Default 
is 10 times neighbors_within_batch times the number of batches. Set to 0 to 
skip.}

\item{set_op_mix_ratio}{Pass to 'set_op_mix_ratio' parameter for 
\code{\link[uwot]{umap}}}

\item{local_connectivity}{Pass to 'local_connectivity' parameter for 
\code{\link[uwot]{umap}}}

\item{seed}{Set a random seed. By default, sets the seed to 42. Setting 
\code{NULL} will not set a seed.}

\item{verbose}{Whether or not to print output to the console}

\item{batch_key}{Column name in meta.data discriminating between your 
batches.}

\item{assay}{Used to construct Graph.}

\item{reduction}{Which dimensional reduction to use for the BBKNN input. 
Default is PCA}

\item{graph_name}{Name of the generated BBKNN graph. Default is "bbknn".}

\item{run_TSNE}{Whether or not to run t-SNE based on BBKNN results.}

\item{TSNE_name}{Name to store t-SNE dimensional reduction.}

\item{TSNE_key}{Specifies the string before the number of the t-SNE dimension 
names. tSNE by default.}

\item{run_UMAP}{Whether or not to run UMAP based on BBKNN results.}

\item{UMAP_name}{Name to store UMAP dimensional reduction.}

\item{UMAP_key}{Specifies the string before the number of the UMAP dimension 
names. tSNE by default.}

\item{return.umap.model}{Whether UMAP will return the uwot model.}

\item{min_dist}{Pass to 'min_dist' parameter for \code{\link[uwot]{umap}}}

\item{spread}{Pass to 'spread' parameter for \code{\link[uwot]{umap}}}
}
\value{
Returns a Seurat object containing a new BBKNN Graph and Neighbor 
data. If run t-SNE or UMAP, will also return corresponded reduction objects.
}
\description{
Batch balanced KNN, altering the KNN procedure to identify each cell’s top 
neighbours in each batch separately instead of the entire cell pool with no 
accounting for batch. The nearest neighbours for each batch are then merged 
to create a final list of neighbours for the cell. Aligns batches in a quick 
and lightweight manner.
}
\examples{
data("panc8_small")
panc8_small <- RunBBKNN(panc8_small, "tech")

}
\references{
Polański, Krzysztof, et al. "BBKNN: fast batch alignment of single cell 
transcriptomes." Bioinformatics 36.3 (2020): 964-965.
}
